/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.helpers;

import alma.archive.database.helpers.ArchiveConfiguration;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.exceptions.general.DatabaseException;
import com.cosylab.cdb.jdal.hibernate.plugin.HibernateWDALConfigurationPlugin;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveHibernateWDALConfigurationPlugin
implements HibernateWDALConfigurationPlugin {
    private DBConfiguration archiveConfig = null;

    public void initialize(Logger logger) {
        try {
            this.archiveConfig = ArchiveConfiguration.instance(logger);
        }
        catch (DatabaseException de) {
            logger.log(Level.FINE, "Exception from ArchiveConfiguration ", de);
            throw new RuntimeException("Failed to obtain ArchiveConfiguration instance.", de);
        }
    }

    public String getName() {
        return "ArchiveConfiguration plugin";
    }

    public String get(String name, String defaultValue) {
        String retVal = this.archiveConfig.get(name);
        if (retVal != null) {
            return retVal;
        }
        return defaultValue;
    }

    public String getBackend() {
        String dbConnection = this.getURL();
        if (dbConnection.indexOf("hsqldb") > 0) {
            return "hsqldb";
        }
        return this.archiveConfig.dbBackend;
    }

    public String getURL() {
        return this.archiveConfig.get("archive.tmcdb.connection");
    }

    public String getUserName() {
        return this.archiveConfig.get("archive.tmcdb.user");
    }

    public String getPassword() {
        return this.archiveConfig.get("archive.tmcdb.passwd");
    }
}

