/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.testsupport;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogRecordCollectingLogger
extends Logger {
    private List<LogRecord> logRecordList = Collections.synchronizedList(new ArrayList());
    private boolean suppressLogs = false;
    private Logger delegate;

    public static synchronized LogRecordCollectingLogger getCollectingLogger(String name) {
        return LogRecordCollectingLogger.getCollectingLogger(name, LogRecordCollectingLogger.class);
    }

    public static synchronized <T extends LogRecordCollectingLogger> T getCollectingLogger(String name, Class<T> loggerClass) {
        LogManager manager = LogManager.getLogManager();
        Logger logger = manager.getLogger(name);
        if (logger != null && !loggerClass.isInstance(logger)) {
            throw new ClassCastException("Logger '" + name + "' is already used and is of wrong type " + logger.getClass().getName());
        }
        LogRecordCollectingLogger myLogger = (LogRecordCollectingLogger)logger;
        if (myLogger == null) {
            try {
                Constructor<T> ctor = loggerClass.getDeclaredConstructor(String.class, String.class);
                myLogger = (LogRecordCollectingLogger)ctor.newInstance(name, null);
                manager.addLogger(myLogger);
                myLogger = (LogRecordCollectingLogger)manager.getLogger(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        myLogger.setLevel(Level.FINEST);
        myLogger.setUseParentHandlers(false);
        ConsoleHandler logHandler = new ConsoleHandler();
        logHandler.setLevel(Level.FINEST);
        myLogger.addHandler(logHandler);
        return (T)myLogger;
    }

    protected LogRecordCollectingLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    @Override
    public void log(LogRecord record) {
        record.getSourceClassName();
        this.logRecordList.add(record);
        if (this.delegate != null && !this.suppressLogs) {
            this.delegate.log(record);
        }
    }

    public LogRecord[] getCollectedLogRecords() {
        return this.logRecordList.toArray(new LogRecord[this.logRecordList.size()]);
    }

    public void clearLogRecords() {
        this.logRecordList.clear();
    }

    public void suppressLogs(boolean suppressLogs) {
        this.suppressLogs = suppressLogs;
    }

    public void setDelegateLogger(Logger delegate) {
        this.delegate = delegate;
        if (delegate == null) {
            this.suppressLogs = true;
        }
    }
}

