/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.vmtools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class LogManagerGui
extends JPanel {
    static final Color BG_NORMAL = Color.white;
    static final Color BG_SELECT = Color.lightGray;
    static final HashMap<Level, Color> level2color = new HashMap();
    TreeM model = new TreeM(null);
    JTree tree = new JTree(this.model);
    LoggerEditor editor;
    QuickLoggerEditor quickEditor;
    JSplitPane splitpane;
    Controls controls;
    static final Vector<Level> LEVELS;

    public static JFrame openFrame(LogManagerGui inst) {
        final JFrame f = new JFrame(LogManagerGui.class.getName());
        f.setDefaultCloseOperation(0);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                int answer = JOptionPane.showConfirmDialog(f, "Really close?", "Close Window", 0);
                if (answer == 0) {
                    f.setVisible(false);
                    f.dispose();
                }
            }
        });
        f.getContentPane().add(inst);
        f.pack();
        f.setVisible(true);
        return f;
    }

    public LogManagerGui() {
        super(new BorderLayout());
        this.tree.addTreeSelectionListener(new TreeS());
        this.tree.setCellRenderer(new TreeR());
        this.quickEditor = new QuickLoggerEditor();
        this.tree.addMouseListener(new TreeL());
        this.editor = new LoggerEditor();
        this.tree.setBackground(Color.white);
        this.controls = new Controls();
        JPanel left = new JPanel(new BorderLayout());
        left.add((Component)new JScrollPane(this.tree), "Center");
        left.add((Component)this.controls, "South");
        this.splitpane = new JSplitPane(1);
        this.splitpane.setLeftComponent(left);
        this.splitpane.setRightComponent(this.editor);
        this.add(this.splitpane);
    }

    protected void message(String msg) {
        String me = LogManagerGui.class.getName();
        me = me.substring(me.lastIndexOf(46) + 1);
        System.out.println(me + ": " + msg);
    }

    public void setFilter(String string) {
        this.controls.txtNameFilter.setText(string);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.populateModel();
        }
        this.splitpane.setDividerLocation(0.66);
        super.setVisible(b);
    }

    public void populateModel() {
        this.populateModel(new String[0]);
    }

    public void populateModel(String[] nameFilter) {
        TreeN node;
        HashMap<Logger, TreeN> reverse = new HashMap<Logger, TreeN>();
        if (this.model.root() != null) {
            this.model.root().removeAllChildren();
        }
        Enumeration<String> en = LogManager.getLogManager().getLoggerNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            if (!this.passesThroughFilter(nameFilter, name)) continue;
            Logger elem = LogManager.getLogManager().getLogger(name);
            node = new TreeN(elem);
            reverse.put(elem, node);
        }
        for (Logger elem : reverse.keySet()) {
            node = (TreeN)reverse.get(elem);
            TreeN pnode = (TreeN)reverse.get(elem.getParent());
            if (pnode == null) {
                this.model.setRoot(node);
                continue;
            }
            pnode.add(node);
        }
        this.model.nodeStructureChanged(this.model.root());
    }

    private boolean passesThroughFilter(String[] nameFilter, String name) {
        for (int i = 0; i < nameFilter.length; ++i) {
            if (!name.startsWith(nameFilter[i])) continue;
            return false;
        }
        return true;
    }

    Color colorFromLevel(Level x) {
        Color ret = level2color.get(x);
        if (ret == null) {
            ret = Color.magenta;
            this.message("no color defined for log-level " + x);
        }
        return ret;
    }

    void editLogger(Logger x) {
        Object level = String.valueOf(x.getLevel());
        if (x.getFilter() instanceof ForceFilter) {
            level = (String)level + " (filter-level: " + ((ForceFilter)x.getFilter()).level + ")";
        }
        this.editor.text2.setText(x.toString() + "\nname=" + x.getName() + "\nlogger-level=" + (String)level + "\nactive-level=" + this.activeLevel(x) + "\neffective-level=" + this.effectiveLevel(x) + "\nhandlers=" + Arrays.toString(x.getHandlers()) + "\nusesParentHandler (i.e. sends output to parent):" + x.getUseParentHandlers() + "\nparent=" + x.getParent());
        this.editor.comboBoxActionListener.x = null;
        if (x.getLevel() == null) {
            this.editor.text.setSelectedItem("(inherited)");
        } else {
            this.editor.text.setSelectedItem(x.getLevel());
        }
        this.editor.comboBoxActionListener.x = x;
    }

    void quickEditLogger(Point p, Logger x) {
        this.quickEditor.use(x);
        this.quickEditor.show(this.tree, p.x, p.y);
    }

    Level decodeLevel(Object level) {
        Level toSet;
        if ("(inherited)".equals(level)) {
            toSet = null;
        } else if (LEVELS.contains(level)) {
            toSet = (Level)level;
        } else {
            String s = level.toString();
            try {
                toSet = Level.parse(s);
            }
            catch (Exception exc) {
                this.message("cannot decode level '" + level + "', using ALL instead");
                toSet = Level.ALL;
            }
        }
        return toSet;
    }

    void doSetLevel(Logger x, Level toSet) {
        if (toSet == null && x.getParent() == null) {
            return;
        }
        this.message("setting logger '" + x.getName() + "' to level '" + toSet + "'");
        if (toSet != null) {
            x.setFilter(new ForceFilter(toSet));
        } else {
            x.setFilter(null);
        }
        x.setLevel(toSet);
        this.tree.repaint();
    }

    Level activeLevel(Logger x) {
        if (x == null) {
            return null;
        }
        if (x.getLevel() == null) {
            return this.activeLevel(x.getParent());
        }
        return x.getLevel();
    }

    Level effectiveLevel(Logger x) {
        Level ret = this.activeLevel(x);
        Filter f = x.getFilter();
        if (f != null && f instanceof ForceFilter) {
            ForceFilter ff = (ForceFilter)f;
            if (ff.level.intValue() > ret.intValue()) {
                ret = ff.level;
            }
        }
        return ret;
    }

    static {
        level2color.put(null, Color.magenta);
        level2color.put(Level.OFF, Color.gray);
        level2color.put(Level.SEVERE, Color.red);
        level2color.put(Level.WARNING, Color.orange);
        level2color.put(Level.INFO, Color.green);
        level2color.put(Level.FINE, Color.green.brighter());
        level2color.put(Level.FINER, Color.green.brighter().brighter());
        level2color.put(Level.FINEST, Color.green.brighter().brighter().brighter());
        level2color.put(Level.CONFIG, Color.pink);
        level2color.put(Level.ALL, Color.blue);
        LEVELS = new Vector<Level>(Arrays.asList(Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL));
    }

    class TreeM
    extends DefaultTreeModel {
        TreeM(TreeN root) {
            super(root);
        }

        TreeN root() {
            return (TreeN)this.root;
        }
    }

    class TreeN
    extends DefaultMutableTreeNode {
        TreeN(Logger x) {
            super(x);
        }

        Logger logger() {
            return (Logger)this.userObject;
        }
    }

    class TreeS
    implements TreeSelectionListener {
        TreeS() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreeN node = (TreeN)e.getPath().getLastPathComponent();
            LogManagerGui.this.editLogger(node.logger());
        }
    }

    class TreeR
    implements TreeCellRenderer {
        JLabel cell = new JLabel();

        TreeR() {
            this.cell.setBackground(BG_SELECT);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TreeN node = (TreeN)value;
            Logger logger = node.logger();
            Object text = logger.getName();
            if (((String)text).equals("")) {
                text = "<Root Logger>";
            }
            Level activeLevel = LogManagerGui.this.activeLevel(logger);
            text = logger.getLevel() != null ? (String)text + ": " + logger.getLevel().getName() : (String)text + ": " + activeLevel + " (inherited)";
            Level effectiveLevel = LogManagerGui.this.effectiveLevel(logger);
            if (effectiveLevel.intValue() != activeLevel.intValue()) {
                text = (String)text + ", " + effectiveLevel + " (filtered)";
            }
            if (selected) {
                this.cell.setOpaque(true);
            } else {
                this.cell.setOpaque(false);
            }
            Color fg = LogManagerGui.this.colorFromLevel(effectiveLevel);
            this.cell.setForeground(fg);
            this.cell.setText((String)text);
            return this.cell;
        }
    }

    class QuickLoggerEditor
    extends JPopupMenu {
        Logger x;
        JMenu handlermenu;

        QuickLoggerEditor() {
            LoggerLevelAction loggerAction = new LoggerLevelAction();
            JMenuItem item = new JMenuItem("(inherited)");
            item.setActionCommand("(inherited)");
            item.addActionListener(loggerAction);
            super.add(item);
            for (int i = 0; i < LEVELS.size(); ++i) {
                String levelName = LEVELS.get(i).getName();
                item = new JMenuItem(levelName);
                item.setActionCommand(levelName);
                item.addActionListener(loggerAction);
                super.add(item);
            }
            HandlerLevelAction handlerAction = new HandlerLevelAction();
            this.handlermenu = new JMenu("Handlers");
            for (int i = 0; i < LEVELS.size(); ++i) {
                String levelName = LEVELS.get(i).getName();
                item = new JMenuItem(levelName);
                item.setActionCommand(levelName);
                item.addActionListener(handlerAction);
                this.handlermenu.add(item);
            }
            super.add(this.handlermenu);
        }

        void use(Logger x) {
            this.x = x;
            this.handlermenu.setEnabled(x.getHandlers().length > 0);
        }

        class LoggerLevelAction
        implements ActionListener {
            LoggerLevelAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QuickLoggerEditor.this.x != null) {
                    LogManagerGui.this.doSetLevel(QuickLoggerEditor.this.x, LogManagerGui.this.decodeLevel(e.getActionCommand()));
                }
            }
        }

        class HandlerLevelAction
        implements ActionListener {
            HandlerLevelAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QuickLoggerEditor.this.x != null) {
                    for (Handler h : QuickLoggerEditor.this.x.getHandlers()) {
                        h.setLevel(LogManagerGui.this.decodeLevel(e.getActionCommand()));
                    }
                }
            }
        }
    }

    class TreeL
    extends MouseAdapter {
        TreeL() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            Point p = e.getPoint();
            TreePath tp = LogManagerGui.this.tree.getClosestPathForLocation(p.x, p.y);
            LogManagerGui.this.tree.setSelectionPath(tp);
            TreeN n = (TreeN)tp.getLastPathComponent();
            LogManagerGui.this.quickEditLogger(p, n.logger());
        }
    }

    class LoggerEditor
    extends JPanel {
        JTextArea text2;
        JComboBox text;
        ActionLi comboBoxActionListener;

        LoggerEditor() {
            super(new BorderLayout());
            Vector<Level> cmbBoxContents = new Vector<Level>(LEVELS);
            cmbBoxContents.insertElementAt((Level)((Object)"(inherited)"), 0);
            this.text = new JComboBox<Level>(cmbBoxContents);
            this.add((Component)this.text, "North");
            this.text2 = new JTextArea();
            this.add((Component)this.text2, "Center");
            this.comboBoxActionListener = new ActionLi();
            this.text.addActionListener(this.comboBoxActionListener);
            this.text.setEditable(true);
        }

        class ActionLi
        implements ActionListener {
            Logger x;

            ActionLi() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (this.x == null) {
                    return;
                }
                Object sel = LogManagerGui.this.editor.text.getSelectedItem();
                if (sel == null) {
                    return;
                }
                LogManagerGui.this.doSetLevel(this.x, LogManagerGui.this.decodeLevel(sel));
            }
        }
    }

    class Controls
    extends JPanel {
        JTextField txtNameFilter;

        Controls() {
            super(new BorderLayout());
            this.add((Component)new JLabel("Don't show: "), "West");
            this.txtNameFilter = new JTextField();
            this.add((Component)this.txtNameFilter, "Center");
            JButton r = new JButton("Refresh");
            r.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StringTokenizer t = new StringTokenizer(Controls.this.txtNameFilter.getText(), ";, ", false);
                    String[] nameFilter = Collections.list(t).toArray(new String[0]);
                    LogManagerGui.this.populateModel(nameFilter);
                }
            });
            this.add((Component)r, "East");
            this.txtNameFilter.setText("sun., java., javax.");
        }
    }

    class ForceFilter
    implements Filter {
        public Level level;
        int threshold;

        ForceFilter(Level level) {
            this.level = level;
            this.threshold = level.intValue();
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            return this.threshold <= record.getLevel().intValue();
        }
    }
}

