/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.votech.plastic.PlasticHubListener;
import uk.ac.starlink.plastic.ApplicationItem;
import uk.ac.starlink.plastic.ApplicationListModel;
import uk.ac.starlink.plastic.HubTestException;
import uk.ac.starlink.plastic.MessageId;
import uk.ac.starlink.plastic.PlasticApplication;
import uk.ac.starlink.plastic.PlasticConnection;
import uk.ac.starlink.plastic.PlasticMonitor;
import uk.ac.starlink.plastic.PlasticUtils;
import uk.ac.starlink.plastic.XmlRpcHub;

public class HubTester {
    private final PlasticHubListener hub_;
    private final URI id_;
    private List monitors_;
    private final Object lock_ = new Object();
    private final boolean abuse_ = false;
    private static final String CLIENT_NAME = "test-driver";
    private static final URI CALC_MSG = PlasticUtils.createURI("ivo://plastic.starlink.ac.uk/msg/calc");
    private static final URI DUMMY_MSG = PlasticUtils.createURI("ivo://plastic.starlink.ac.uk/msg/not-a-message");
    private static final String PLUS = "plus";
    private static final String MINUS = "minus";
    private static final File CONFIG_FILE = new File(System.getProperty("user.home"), ".plastic");

    public HubTester(PlasticHubListener hub) throws HubTestException {
        this.hub_ = hub;
        this.id_ = hub.registerNoCallBack(CLIENT_NAME);
        this.assertTrue(this.id_ != null);
        this.monitors_ = this.getMonitors();
    }

    public URI getId() {
        return this.id_;
    }

    public PlasticHubListener getHub() {
        return this.hub_;
    }

    public void dispose() throws HubTestException {
        this.hub_.unregister(this.id_);
    }

    public void exerciseHub() throws HubTestException {
        if (this.hub_ == null || this.id_ == null) {
            throw new IllegalStateException("Not initialised");
        }
        this.assertTrue(CONFIG_FILE.exists());
        try {
            this.exerciseCounters();
            this.exerciseMonitors();
        }
        catch (IOException e) {
            throw new HubTestException("Hub failed", e);
        }
        catch (InterruptedException e) {
            throw new HubTestException("Hub failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exerciseCounters() throws HubTestException, IOException, InterruptedException {
        int n2;
        int n1;
        Counter c1 = new Counter();
        Counter c2 = new Counter();
        PlasticConnection conn1 = PlasticUtils.registerRMI(c1);
        URI id1 = conn1.getId();
        this.assertTrue(this.hub_.getMessageRegisteredIds(CALC_MSG) != null);
        this.assertEquals(this.removeMonitorsList(this.hub_.getMessageRegisteredIds(CALC_MSG)), Collections.singletonList(id1));
        this.assertEquals(1, this.removeMonitorsList(this.hub_.getMessageRegisteredIds(CALC_MSG)).size());
        Object soleId = this.removeMonitorsList(this.hub_.getMessageRegisteredIds(CALC_MSG)).get(0);
        this.assertEquals(id1, soleId);
        this.assertEquals(HubTester.intMap(new URI[]{id1}, new int[]{0}), this.removeMonitorsMap(this.hub_.request(this.id_, CALC_MSG, HubTester.calcArgs(PLUS, 0))));
        PlasticConnection conn2 = PlasticUtils.registerXMLRPC(c2);
        URI id2 = conn2.getId();
        this.assertEquals(new HashSet<URI>(Arrays.asList(id1, id2)), new HashSet(this.removeMonitorsList(this.hub_.getMessageRegisteredIds(CALC_MSG))));
        this.assertEquals(HubTester.intMap(new URI[]{id1, id2}, new int[]{10, 10}), this.removeMonitorsMap(this.hub_.request(this.id_, CALC_MSG, HubTester.calcArgs(PLUS, 10))));
        this.assertEquals(HubTester.intMap(new URI[]{id1, id2}, new int[]{5, 5}), this.removeMonitorsMap(this.hub_.request(this.id_, CALC_MSG, HubTester.calcArgs(MINUS, 5))));
        this.assertEquals(5, c1.sum_);
        this.assertEquals(5, c2.sum_);
        this.assertEquals(HubTester.intMap(new URI[]{id1}, new int[]{95}), this.hub_.requestToSubset(this.id_, CALC_MSG, HubTester.calcArgs(PLUS, 90), Arrays.asList(id1)));
        this.assertEquals(95, c1.sum_);
        this.assertEquals(5, c2.sum_);
        this.assertEquals(HubTester.intMap(new URI[]{id2}, new int[]{85}), this.hub_.requestToSubset(this.id_, CALC_MSG, HubTester.calcArgs(PLUS, 80), Arrays.asList(id2)));
        this.assertEquals(95, c1.sum_);
        this.assertEquals(85, c2.sum_);
        Object object = this.lock_;
        synchronized (object) {
            n1 = c1.nreq_;
            n2 = c2.nreq_;
            PlasticUtils.singleRequestAsynch("poke", CALC_MSG, HubTester.calcArgs(MINUS, 5));
            while (c1.nreq_ == n1 || c2.nreq_ == n2) {
                this.lock_.wait();
            }
        }
        this.assertEquals(90, c1.sum_);
        this.assertEquals(80, c2.sum_);
        object = this.lock_;
        synchronized (object) {
            n1 = c1.nreq_;
            this.hub_.requestToSubsetAsynch(this.id_, CALC_MSG, HubTester.calcArgs(MINUS, 10), Arrays.asList(id1));
            while (c1.nreq_ == n1) {
                this.lock_.wait();
            }
        }
        this.assertEquals(80, c1.sum_);
        this.assertEquals(80, c2.sum_);
        object = this.lock_;
        synchronized (object) {
            n1 = c1.nreq_;
            n2 = c2.nreq_;
            this.hub_.requestAsynch(this.id_, CALC_MSG, HubTester.calcArgs(PLUS, 21));
            while (c1.nreq_ == n1 || c2.nreq_ == n2) {
                this.lock_.wait();
            }
        }
        this.assertEquals(101, c1.sum_);
        this.assertEquals(101, c2.sum_);
        this.assertEquals(HubTester.objMap(new URI[]{id1}, new String[]{"counter"}), this.hub_.requestToSubset(this.id_, PlasticUtils.createURI("ivo://votech.org/info/getName"), new ArrayList(), Arrays.asList(id1)));
        this.assertTrue(this.hub_.getRegisteredIds().contains(id1));
        this.assertTrue(this.hub_.getMessageRegisteredIds(CALC_MSG).contains(id1));
        this.assertTrue(!this.hub_.getMessageRegisteredIds(DUMMY_MSG).contains(id1));
        conn1.unregister();
        this.assertTrue(!this.hub_.getRegisteredIds().contains(id1));
        this.assertTrue(!this.hub_.getMessageRegisteredIds(CALC_MSG).contains(id1));
        this.assertTrue(this.hub_.getRegisteredIds().contains(id2));
        this.assertTrue(this.hub_.getMessageRegisteredIds(CALC_MSG).contains(id2));
        conn2.unregister();
        this.assertTrue(!this.hub_.getRegisteredIds().contains(id2));
        this.assertTrue(!this.hub_.getMessageRegisteredIds(CALC_MSG).contains(id2));
        c1.dispose();
        c2.dispose();
    }

    private void exerciseMonitors() throws IOException, HubTestException, InterruptedException {
        PlasticMonitor mon1 = new PlasticMonitor("mon1", true, null, null);
        PlasticMonitor mon2 = new PlasticMonitor("mon2", false, null, null);
        ApplicationItem[] regApps = PlasticUtils.getRegisteredApplications(this.hub_);
        ApplicationListModel appList1 = new ApplicationListModel(regApps);
        ApplicationListModel appList2 = new ApplicationListModel(regApps);
        mon1.setListModel(appList1);
        mon2.setListModel(appList2);
        mon1.setHub(this.hub_);
        mon2.setHub(this.hub_);
        PlasticConnection conn1 = PlasticUtils.registerRMI(mon1);
        URI id1 = conn1.getId();
        this.assertTrue(this.hub_.getRegisteredIds().contains(id1));
        PlasticConnection conn2 = PlasticUtils.registerXMLRPC(mon2);
        URI id2 = conn2.getId();
        this.assertTrue(this.hub_.getRegisteredIds().contains(id2));
        Thread.sleep(2000L);
        this.assertTrue(this.hub_.getRegisteredIds().contains(id1));
        this.assertTrue(this.hub_.getRegisteredIds().contains(id2));
        conn1.unregister();
        this.assertTrue(!this.hub_.getRegisteredIds().contains(id1));
        conn2.unregister();
        this.assertTrue(!this.hub_.getRegisteredIds().contains(id2));
    }

    private final List getMonitors() throws HubTestException {
        List monitors = this.hub_.getMessageRegisteredIds(DUMMY_MSG);
        this.assertTrue(monitors != null);
        float hubVers = this.getHubVersion();
        if ((double)hubVers > 0.49) {
            this.assertTrue(monitors.isEmpty());
        }
        return monitors;
    }

    private List removeMonitorsList(List list) {
        if (list == null) {
            return null;
        }
        list = new ArrayList(list);
        list.removeAll(this.monitors_);
        return list;
    }

    private Map removeMonitorsMap(Map map) {
        if (map == null) {
            return null;
        }
        map = new HashMap(map);
        Iterator it = this.monitors_.iterator();
        while (it.hasNext()) {
            map.remove((URI)it.next());
        }
        return map;
    }

    private final float getHubVersion() throws HubTestException {
        URI hubId = this.hub_.getHubId();
        Map vMap = this.hub_.requestToSubset(this.id_, MessageId.INFO_GETVERSION, new ArrayList(), Collections.singletonList(hubId));
        String shubVers = (String)vMap.get(hubId);
        this.assertTrue(shubVers != null);
        try {
            return Float.parseFloat(shubVers);
        }
        catch (NumberFormatException e) {
            throw new HubTestException("Version string \"" + shubVers + "\" doesn't have numeric form", e);
        }
    }

    private void assertTrue(boolean test) throws HubTestException {
        if (!test) {
            throw new HubTestException("Hub test failed");
        }
    }

    private void assertEquals(Object o1, Object o2) throws HubTestException {
        if (!(o1 == null && o2 == null || o1 != null && o1.equals(o2))) {
            throw new HubTestException("Hub test failed: " + o1 + " != " + o2);
        }
    }

    private void assertEquals(int i1, int i2) throws HubTestException {
        if (i1 != i2) {
            throw new HubTestException("Hub test failed: " + i1 + " != " + i2);
        }
    }

    private static List calcArgs(String op, int value) {
        return Arrays.asList(op, new Integer(value));
    }

    private static Map intMap(URI[] ids, int[] values) {
        HashMap<URI, Integer> map = new HashMap<URI, Integer>();
        for (int i = 0; i < ids.length; ++i) {
            map.put(ids[i], new Integer(values[i]));
        }
        return map;
    }

    private static Map objMap(URI[] ids, Object[] values) {
        HashMap<URI, Object> map = new HashMap<URI, Object>();
        for (int i = 0; i < ids.length; ++i) {
            map.put(ids[i], values[i]);
        }
        return map;
    }

    public static void testHub() throws HubTestException {
        XmlRpcHub xmlrpcHub;
        PlasticHubListener rmiHub;
        try {
            rmiHub = PlasticUtils.getLocalHub();
            xmlrpcHub = new XmlRpcHub(PlasticUtils.getXmlRpcUrl(), rmiHub);
        }
        catch (IOException e) {
            throw new HubTestException("Trouble acquiring hub", e);
        }
        HubTester.testHub(rmiHub);
        HubTester.testHub(xmlrpcHub);
        HubTester.testHub(rmiHub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testHub(PlasticHubListener hub) throws HubTestException {
        HubTester htest = new HubTester(hub);
        try {
            htest.exerciseHub();
        }
        finally {
            htest.dispose();
        }
    }

    public static void main(String[] args) throws HubTestException {
        String usage = "\nUsage:\n      " + HubTester.class.getName() + "\n";
        if (args.length == 1 && args[0].startsWith("-h")) {
            System.out.println(usage);
            return;
        }
        if (args.length > 0) {
            System.err.println(usage);
            System.exit(1);
        }
        try {
            HubTester.testHub();
            System.exit(0);
        }
        catch (Throwable error) {
            error.printStackTrace();
            System.exit(1);
        }
    }

    private class Counter
    implements PlasticApplication {
        private int sum_;
        private int nreq_;
        private Throwable error_;

        private Counter() {
        }

        public String getName() {
            return "counter";
        }

        public URI[] getSupportedMessages() {
            return new URI[]{CALC_MSG};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object perform(URI sender, URI message, List args) {
            try {
                Object mode;
                if (message.equals(CALC_MSG)) {
                    mode = (String)args.get(0);
                    int value = (Integer)args.get(1);
                    HubTester.this.assertEquals(2, args.size());
                    if (((String)mode).equals(HubTester.PLUS)) {
                        this.sum_ += value;
                    } else if (((String)mode).equals(HubTester.MINUS)) {
                        this.sum_ -= value;
                    } else {
                        throw new HubTestException("Mangled mode \"" + (String)mode + "\"?");
                    }
                }
                ++this.nreq_;
                mode = HubTester.this.lock_;
                synchronized (mode) {
                    HubTester.this.lock_.notifyAll();
                }
                return new Integer(this.sum_);
            }
            catch (Throwable error) {
                this.error_ = error;
                return new Integer(this.sum_);
            }
        }

        public void dispose() throws HubTestException {
            if (this.error_ != null) {
                throw new HubTestException("Deferred error from client: " + this.error_.getMessage(), this.error_);
            }
        }
    }
}

