/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.Histogram;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.operator.TransposeType;

public class ImageOps {
    public static double[] minMax(PlanarImage im, ROI roi, int xPeriod, int yPeriod, double ignore) {
        Object o;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(roi);
        pb.add(xPeriod);
        pb.add(yPeriod);
        pb.add(ignore);
        im = JAI.create((String)"minmax", (ParameterBlock)pb, null);
        if (im != null && (o = im.getProperty("minmax")) != null) {
            return (double[])o;
        }
        return new double[2];
    }

    public static double[] cutLevel(PlanarImage im, ROI roi, double ignore, double median) {
        Object o;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(roi);
        pb.add(ignore);
        pb.add(median);
        im = JAI.create((String)"cutlevel", (ParameterBlock)pb, null);
        if (im != null && (o = im.getProperty("cutlevel")) != null) {
            return (double[])o;
        }
        return new double[2];
    }

    public static double[][] extrema(PlanarImage im, ROI roi, int xPeriod, int yPeriod) {
        Object o;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(roi);
        pb.add(xPeriod);
        pb.add(yPeriod);
        im = JAI.create((String)"extrema", (ParameterBlock)pb, null);
        if (im != null && (o = im.getProperty("extrema")) != null) {
            return (double[][])o;
        }
        return new double[2][1];
    }

    public static double[] mean(PlanarImage im, ROI roi, int xPeriod, int yPeriod) {
        Object o;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(roi);
        pb.add(xPeriod);
        pb.add(yPeriod);
        im = JAI.create((String)"mean", (ParameterBlock)pb, null);
        if (im != null && (o = im.getProperty("mean")) != null) {
            return (double[])o;
        }
        return new double[2];
    }

    public static PlanarImage rescale(PlanarImage im, double factor, double offset, RenderingHints hints) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        double[] f = new double[]{factor};
        double[] o = new double[]{offset};
        pb.add(f);
        pb.add(o);
        return JAI.create((String)"Rescale", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static PlanarImage format(PlanarImage im, int dataType) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(dataType);
        return JAI.create((String)"Format", (ParameterBlock)pb, null);
    }

    public static PlanarImage scale(PlanarImage im, float xScale, float yScale, float xTrans, float yTrans, Interpolation interpolation, RenderingHints hints) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(xScale);
        pb.add(yScale);
        pb.add(xTrans);
        pb.add(yTrans);
        pb.add(interpolation);
        return JAI.create((String)"Scale", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static PlanarImage rotate(PlanarImage im, float x, float y, float angle, Interpolation interpolation, RenderingHints hints) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(x);
        pb.add(y);
        pb.add(angle);
        pb.add(interpolation);
        return JAI.create((String)"Rotate", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static PlanarImage crop(PlanarImage im, float x, float y, float width, float height) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(x);
        pb.add(y);
        pb.add(width);
        pb.add(height);
        return JAI.create((String)"Crop", (ParameterBlock)pb, null);
    }

    public static PlanarImage translate(PlanarImage im, float x, float y, Interpolation interpolation) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(x);
        pb.add(y);
        pb.add(interpolation);
        return JAI.create((String)"Translate", (ParameterBlock)pb, null);
    }

    public static PlanarImage transpose(PlanarImage im, TransposeType type) {
        return JAI.create((String)"Transpose", (RenderedImage)im, (Object)type);
    }

    public static PlanarImage lookup(PlanarImage im, LookupTableJAI lookupTable) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(lookupTable);
        return JAI.create((String)"Lookup", (ParameterBlock)pb, null);
    }

    public static PlanarImage clamp(PlanarImage im, double low, double high) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        double[] lowAr = new double[]{low};
        double[] highAr = new double[]{high};
        pb.add(lowAr);
        pb.add(highAr);
        return JAI.create((String)"Clamp", (ParameterBlock)pb, null);
    }

    public static Histogram histogram(PlanarImage im, ROI roi, int xPeriod, int yPeriod, int[] numBins, double[] lowValue, double[] highValue) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(roi);
        pb.add(xPeriod);
        pb.add(yPeriod);
        pb.add(numBins);
        pb.add(lowValue);
        pb.add(highValue);
        im = JAI.create((String)"Histogram", (ParameterBlock)pb, null);
        return (Histogram)im.getProperty("histogram");
    }
}

