/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ShortStatistics
extends ImageStatistics {
    public ShortStatistics(ImageProcessor ip) {
        this(ip, 27, null);
    }

    /*
     * Unable to fully structure code
     */
    public ShortStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        super();
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.setup(ip, cal);
        this.nBins = 256;
        minT = ip.getMinThreshold();
        if ((mOptions & 256) == 0) ** GOTO lbl-1000
        if (minT == -808080.0) lbl-1000:
        // 2 sources

        {
            minThreshold = 0;
            maxThreshold = 65535;
        } else {
            minThreshold = (int)minT;
            maxThreshold = (int)ip.getMaxThreshold();
        }
        hist = ip.getHistogram();
        this.histogram16 = hist;
        cTable = cal != null ? cal.getCTable() : null;
        this.getRawMinAndMax(hist, minThreshold, maxThreshold);
        this.histMin = this.min;
        this.histMax = this.max;
        this.getStatistics(ip, hist, (int)this.min, (int)this.max, cTable);
        if ((mOptions & 8) != 0) {
            this.getMode();
        }
        if ((mOptions & 2048) != 0) {
            this.fitEllipse(ip);
        } else if ((mOptions & 32) != 0) {
            this.getCentroid(ip, minThreshold, maxThreshold);
        }
        if ((mOptions & 393280) != 0) {
            this.calculateMoments(ip, minThreshold, maxThreshold, cTable);
        }
        if ((mOptions & 16) != 0 && cTable != null) {
            this.getCalibratedMinAndMax(hist, (int)this.min, (int)this.max, cTable);
        }
        if ((mOptions & 65536) != 0) {
            this.calculateMedian(hist, (int)this.histMin, cal);
        }
        if ((mOptions & 524288) != 0) {
            this.calculateAreaFraction(ip, hist);
        }
    }

    void getRawMinAndMax(int[] hist, int minThreshold, int maxThreshold) {
        int max;
        int min;
        for (min = minThreshold; hist[min] == 0 && min < 65535; ++min) {
        }
        this.min = min;
        for (max = maxThreshold; hist[max] == 0 && max > 0; --max) {
        }
        this.max = max;
    }

    void getStatistics(ImageProcessor ip, int[] hist, int min, int max, float[] cTable) {
        double sum = 0.0;
        double sum2 = 0.0;
        this.nBins = ip.getHistogramSize();
        this.histMin = ip.getHistogramMin();
        this.histMax = ip.getHistogramMax();
        if (this.histMin == 0.0 && this.histMax == 0.0) {
            this.histMin = min;
            this.histMax = max;
        } else {
            if ((double)min < this.histMin) {
                min = (int)this.histMin;
            }
            if ((double)max > this.histMax) {
                max = (int)this.histMax;
            }
        }
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double scale = 1.0 / this.binSize;
        int hMin = (int)this.histMin;
        this.histogram = new int[this.nBins];
        int maxCount = 0;
        for (int i = min; i <= max; ++i) {
            int count = hist[i];
            if (count > maxCount) {
                maxCount = count;
                this.dmode = i;
            }
            this.pixelCount += count;
            double value = cTable == null ? (double)i : (double)cTable[i];
            sum += value * (double)count;
            sum2 += value * value * (double)count;
            int index = (int)(scale * (double)(i - hMin));
            if (index >= this.nBins) {
                index = this.nBins - 1;
            }
            int n = index;
            this.histogram[n] = this.histogram[n] + count;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.umean = this.mean = sum / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, sum, sum2);
        if (cTable != null) {
            this.dmode = cTable[(int)this.dmode];
        }
    }

    void getMode() {
        this.maxCount = 0;
        for (int i = 0; i < this.nBins; ++i) {
            int count = this.histogram[i];
            if (count <= this.maxCount) continue;
            this.maxCount = count;
            this.mode = i;
        }
    }

    void getCentroid(ImageProcessor ip, int minThreshold, int maxThreshold) {
        short[] pixels = (short[])ip.getPixels();
        byte[] mask = ip.getMaskArray();
        boolean limit = minThreshold > 0 || maxThreshold < 65535;
        int count = 0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                if (mask == null || mask[mi++] != 0) {
                    if (limit) {
                        int v = pixels[i] & 0xFFFF;
                        if (v >= minThreshold && v <= maxThreshold) {
                            ++count;
                            xsum += (double)x;
                            ysum += (double)y;
                        }
                    } else {
                        ++count;
                        xsum += (double)x;
                        ysum += (double)y;
                    }
                }
                ++i;
            }
            ++y;
            ++my;
        }
        this.xCentroid = xsum / (double)count + 0.5;
        this.yCentroid = ysum / (double)count + 0.5;
        if (this.cal != null) {
            this.xCentroid = this.cal.getX(this.xCentroid);
            this.yCentroid = this.cal.getY(this.yCentroid, this.height);
        }
    }

    void calculateMoments(ImageProcessor ip, int minThreshold, int maxThreshold, float[] cTable) {
        short[] pixels = (short[])ip.getPixels();
        byte[] mask = ip.getMaskArray();
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                int iv;
                if ((mask == null || mask[mi++] != 0) && (iv = pixels[i] & 0xFFFF) >= minThreshold && iv <= maxThreshold) {
                    double v = cTable != null ? (double)cTable[iv] : (double)iv;
                    double v2 = v * v;
                    sum1 += v;
                    sum2 += v2;
                    sum3 += v * v2;
                    sum4 += v2 * v2;
                    xsum += (double)x * v;
                    ysum += (double)y * v;
                }
                ++i;
            }
            ++y;
            ++my;
        }
        double mean2 = this.mean * this.mean;
        double variance = sum2 / (double)this.pixelCount - mean2;
        double sDeviation = Math.sqrt(variance);
        this.skewness = ((sum3 - 3.0 * this.mean * sum2) / (double)this.pixelCount + 2.0 * this.mean * mean2) / (variance * sDeviation);
        this.kurtosis = ((sum4 - 4.0 * this.mean * sum3 + 6.0 * mean2 * sum2) / (double)this.pixelCount - 3.0 * mean2 * mean2) / (variance * variance) - 3.0;
        this.xCenterOfMass = xsum / sum1 + 0.5;
        this.yCenterOfMass = ysum / sum1 + 0.5;
        if (this.cal != null) {
            this.xCenterOfMass = this.cal.getX(this.xCenterOfMass);
            this.yCenterOfMass = this.cal.getY(this.yCenterOfMass, this.height);
        }
    }

    void getCalibratedMinAndMax(int[] hist, int minValue, int maxValue, float[] cTable) {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        double v = 0.0;
        for (int i = minValue; i <= maxValue; ++i) {
            if (hist[i] <= 0) continue;
            v = cTable[i];
            if (v < this.min) {
                this.min = v;
            }
            if (!(v > this.max)) continue;
            this.max = v;
        }
    }
}

