/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.distorter;

import skyview.geometry.Distorter;
import skyview.geometry.Transformer;

public class Neat
extends Distorter {
    private double x0;
    private double y0;
    private double scale;

    @Override
    public String getName() {
        return "NeatDistorter";
    }

    @Override
    public String getDescription() {
        return "Invert a radial cubic distortion (find x from y where y=x+d x^3)";
    }

    @Override
    public Distorter inverse() {
        return new NeatInv();
    }

    @Override
    public boolean isInverse(Transformer test) {
        try {
            return test.inverse().inverse() == this;
        }
        catch (Exception e) {
            throw new Error("Unexpected exception in NeatDistorter.isInverse:" + e);
        }
    }

    public Neat(double scale, double x0, double y0) {
        this.x0 = x0;
        this.y0 = y0;
        this.scale = scale;
    }

    @Override
    public void transform(double[] in, double[] out) {
        double x = in[0];
        double dx = x - this.x0;
        double y = in[1];
        double dy = y - this.y0;
        double rp = Math.sqrt(dx * dx + dy * dy);
        if (rp > 0.0) {
            double delta;
            double t = rp + this.scale * rp * rp * rp;
            int loopLimit = 0;
            do {
                delta = rp - t * (1.0 - this.scale * t * t);
                t += delta / (1.0 - 3.0 * this.scale * t * t);
            } while (Math.abs(delta) > 1.0E-10 && ++loopLimit < 10);
            dx = dx * t / rp;
            dy = dy * t / rp;
        }
        out[0] = dx + this.x0;
        out[1] = dy + this.y0;
    }

    public class NeatInv
    extends Distorter {
        @Override
        public String getName() {
            return "NeatInv";
        }

        public String getDescrition() {
            return "Perform radial distortion y = x + d x^3";
        }

        @Override
        public boolean isInverse(Transformer test) {
            return test == Neat.this;
        }

        @Override
        public Distorter inverse() {
            return Neat.this;
        }

        @Override
        public void transform(double[] in, double[] out) {
            double dy;
            double x = in[0];
            double y = in[1];
            double dx = x - Neat.this.x0;
            double r = Math.sqrt(dx * dx + (dy = y - Neat.this.y0) * dy);
            if (r > 0.0) {
                double rp = Neat.this.scale * r * r * r;
                dx = dx * rp / r;
                dy = dy * rp / r;
                out[0] = x - dx;
                out[1] = y - dy;
            } else {
                out[0] = in[0];
                out[1] = in[1];
            }
        }
    }
}

