/*
 * Decompiled with CFR 0.152.
 */
package skyview.process.expfinder;

import skyview.executive.Settings;
import skyview.geometry.Converter;
import skyview.geometry.Sampler;
import skyview.process.ExposureFinder;
import skyview.survey.FitsImage;
import skyview.survey.Image;

public class ExposureFile
implements ExposureFinder {
    public String expMatchStr = "^(.*)(\\.fits(.gz)?)$";
    public String expOutStr = "$1.exp.$2";
    private Image input;
    private Image expOut;
    private FitsImage expImage;
    private Converter trans;
    private int width;
    private double[] coords;
    private Sampler newSamp;

    public ExposureFile() {
        if (Settings.has("ExposureFileMatch")) {
            this.expMatchStr = Settings.get("ExposureFileMatch");
        }
        if (Settings.has("ExposureFileGen")) {
            this.expOutStr = Settings.get("ExposureFileGen");
        }
    }

    @Override
    public void setImage(Image input, Image output, Sampler samp) {
        try {
            String inpName = input.getName();
            String newFile = inpName.replaceAll(this.expMatchStr, this.expOutStr);
            this.expImage = new FitsImage(newFile);
            this.trans = new Converter();
            try {
                this.trans.add(output.getTransformer().inverse());
                this.trans.add(this.expImage.getTransformer());
            }
            catch (Exception e) {
                System.err.println("Unable to set exposure image transformation for " + newFile);
                throw new Error("Invalid exposure file");
            }
            double[] expData = new double[output.getWidth() * output.getHeight()];
            this.expOut = new Image(expData, output.getWCS(), output.getWidth(), output.getHeight());
            this.newSamp = (Sampler)samp.clone();
            this.newSamp.setInput(this.expImage);
            this.newSamp.setOutput(this.expOut);
            this.newSamp.setTransform(this.trans);
        }
        catch (Exception e) {
            System.err.println("  Error trying to get exposure from image:" + e);
        }
    }

    @Override
    public double getExposure(int pixel) {
        this.newSamp.sample(pixel);
        return this.expOut.getData(pixel);
    }
}

