/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.formatters;

import alma.ACSLoggingLog.LogBinaryRecord;
import alma.ACSLoggingLog.LogBinaryRecordHelper;
import alma.ACSLoggingLog.NameValue;
import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogRecord;
import alma.acs.logging.LogParameterUtil;
import alma.acs.logging.formatters.AcsLogFormatter;
import alma.acs.logging.level.AcsLogLevelDefinition;
import alma.acs.util.IsoDateFormat;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import java.util.logging.LogRecord;
import org.omg.CORBA.Any;

public class AcsBinLogFormatter
extends AcsLogFormatter {
    @Override
    public Any formatAny(Any anyLogRecord, LogRecord logRecord) {
        LogBinaryRecord binLogRecord = this.formatBinary(logRecord);
        LogBinaryRecordHelper.insert((Any)anyLogRecord, (LogBinaryRecord)binLogRecord);
        return anyLogRecord;
    }

    LogBinaryRecord formatBinary(LogRecord logRecord) {
        long logId;
        String hostName;
        String Routine;
        long line;
        LogBinaryRecord rLog = new LogBinaryRecord();
        AcsLogLevel acsLevel = AcsLogLevel.getNativeLevel(logRecord.getLevel());
        if (acsLevel == null) {
            return null;
        }
        AcsLogLevelDefinition acsCoreLevel = acsLevel.getAcsLevel();
        Date date = new Date(logRecord.getMillis());
        String TimeStamp = IsoDateFormat.formatDate((Date)date);
        LogParameterUtil logParamUtil = new LogParameterUtil(logRecord);
        rLog.type = (short)acsCoreLevel.value;
        rLog.TimeStamp = TimeStamp;
        String file = logRecord.getSourceClassName();
        if (file == null) {
            if (acsCoreLevel == AcsLogLevelDefinition.DEBUG) {
                rLog.File = "unknown";
            }
        } else {
            rLog.File = file;
        }
        if ((line = logParamUtil.extractLongProperty("Line", -1L)) < 0L) {
            if (acsCoreLevel == AcsLogLevelDefinition.TRACE || acsCoreLevel == AcsLogLevelDefinition.DEBUG) {
                rLog.Line = 0;
            }
        } else {
            rLog.Line = (int)line;
        }
        if ((Routine = logRecord.getSourceMethodName()) == null) {
            if (acsCoreLevel == AcsLogLevelDefinition.TRACE) {
                rLog.Routine = "unknown";
            }
        } else {
            rLog.Routine = Routine;
        }
        if ((hostName = logParamUtil.extractStringProperty("HostName", null)) == null || hostName.length() == 0) {
            hostName = this.getLocalHostName();
        }
        rLog.Host = hostName;
        String process = logRecord.getLoggerName();
        rLog.Process = process != null ? "LoggerName: " + process : "";
        String sourceObject = logRecord.getLoggerName();
        rLog.SourceObject = sourceObject != null ? sourceObject : "";
        String threadName = logParamUtil.extractStringProperty("ThreadName", null);
        rLog.Thread = threadName != null && threadName.length() > 0 ? threadName : (logRecord.getThreadID() >= 0 ? "" + logRecord.getThreadID() : "");
        String context = logParamUtil.extractStringProperty("Context", null);
        rLog.LogContext = context != null ? context : "";
        rLog.StackId = "";
        rLog.StackLevel = 0;
        if (acsCoreLevel.compareTo(AcsLogLevelDefinition.WARNING) >= 0) {
            String stackId = logParamUtil.extractStringProperty("StackId", null);
            rLog.StackId = stackId == null ? "unknown" : stackId;
            long stackLevel = logParamUtil.extractLongProperty("StackLevel", -1L);
            if (stackLevel > 0L) {
                rLog.StackLevel = (int)stackLevel;
            }
        }
        rLog.LogId = (logId = logRecord.getSequenceNumber()) >= 0L ? "" + logId : "";
        String uri = logParamUtil.extractStringProperty("Uri", null);
        rLog.Uri = uri != null ? uri : "";
        long priority = logParamUtil.extractLongProperty("Priority", acsCoreLevel.value);
        rLog.Priority = priority != (long)acsCoreLevel.value ? (int)priority : -1;
        rLog.MsgData = logRecord.getMessage() != null ? logRecord.getMessage() : "";
        if (logRecord instanceof AcsLogRecord) {
            rLog.Audience = ((AcsLogRecord)logRecord).getAudience();
            rLog.Array = ((AcsLogRecord)logRecord).getArray();
            rLog.Antenna = ((AcsLogRecord)logRecord).getAntenna();
        }
        rLog.attributes = new NameValue[0];
        NameValue[] log_data = new NameValue[257];
        int i = 0;
        try {
            Throwable loggedThrowable = logRecord.getThrown();
            if (loggedThrowable != null) {
                StringWriter exWriter = new StringWriter();
                loggedThrowable.printStackTrace(new PrintWriter(exWriter));
                log_data[i++] = new NameValue("LoggedException", exWriter.toString());
            }
            for (Object e : logParamUtil.getNonSpecialPropertiesMapParameters()) {
                if (i >= 255) break;
                if (e instanceof Map) {
                    Map propertiesMap = (Map)e;
                    for (Object keyName : propertiesMap.keySet()) {
                        String value = propertiesMap.get(keyName).toString();
                        log_data[i++] = new NameValue(keyName.toString(), value);
                    }
                    continue;
                }
                String value = e.toString();
                log_data[i++] = new NameValue("LoggedParameter", value);
            }
        }
        catch (Exception e) {
            String value = e.toString();
            log_data[i++] = new NameValue("DataConstructionError", value);
        }
        rLog.log_data = new NameValue[i];
        for (int j = 0; j < i; ++j) {
            rLog.log_data[j] = log_data[j];
        }
        return rLog;
    }

    @Override
    public String format(LogRecord record) {
        return "Error: only binary format available!";
    }
}

