/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.MarkShape;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.StyleSet;
import uk.ac.starlink.ttools.plot.Styles;

public class MarkStyles {
    public static StyleSet points(String name) {
        return MarkStyles.points(name, Styles.COLORS);
    }

    public static StyleSet points(final String name, final Color[] colors) {
        return new StyleSet(){

            public String getName() {
                return name;
            }

            public Style getStyle(int index) {
                Color color = colors[Math.abs(index) % colors.length];
                return MarkShape.POINT.getStyle(color, 1);
            }
        };
    }

    public static StyleSet spots(final String name, final int size) {
        return new StyleSet(){

            public String getName() {
                return name;
            }

            public Style getStyle(int index) {
                return MarkShape.FILLED_CIRCLE.getStyle(Styles.getColor(index), size);
            }
        };
    }

    public static StyleSet openShapes(final String name, final int size, final Color color) {
        final MarkShape[] shapes = new MarkShape[]{MarkShape.CROSS, MarkShape.CROXX, MarkShape.OPEN_CIRCLE, MarkShape.OPEN_SQUARE, MarkShape.OPEN_DIAMOND, MarkShape.OPEN_TRIANGLE_UP, MarkShape.OPEN_TRIANGLE_DOWN};
        return new StyleSet(){

            public String getName() {
                return name;
            }

            public Style getStyle(int index) {
                Color col = color == null ? Styles.getColor(index) : color;
                MarkShape shape = shapes[Math.abs(index) % shapes.length];
                return shape.getStyle(col, size);
            }
        };
    }

    public static StyleSet filledShapes(final String name, final int size, final Color color) {
        final MarkShape[] shapes = new MarkShape[]{MarkShape.FILLED_CIRCLE, MarkShape.FILLED_SQUARE, MarkShape.FILLED_DIAMOND, MarkShape.FILLED_TRIANGLE_UP, MarkShape.FILLED_TRIANGLE_DOWN};
        return new StyleSet(){

            public String getName() {
                return name;
            }

            public Style getStyle(int index) {
                Color col = color == null ? Styles.getColor(index) : color;
                MarkShape shape = shapes[Math.abs(index) % shapes.length];
                return shape.getStyle(col, size);
            }
        };
    }

    public static StyleSet faded(final String name, final StyleSet base, final int opaqueLimit) {
        if (opaqueLimit < 1) {
            throw new IllegalArgumentException();
        }
        return new StyleSet(){

            public String getName() {
                return name;
            }

            public Style getStyle(int index) {
                MarkStyle style = (MarkStyle)base.getStyle(index);
                style.setOpaqueLimit(opaqueLimit);
                return style;
            }
        };
    }

    public static Icon getIcon(final StyleSet styleSet) {
        int nmark = 5;
        int separation = 5;
        int w = 20;
        int h = 0;
        for (int i = 0; i < 5; ++i) {
            Icon icon = styleSet.getStyle(i).getLegendIcon();
            w += icon.getIconWidth();
            h = Math.max(h, icon.getIconHeight());
        }
        final int width = w;
        final int height = h;
        return new Icon(){

            public int getIconHeight() {
                return height;
            }

            public int getIconWidth() {
                return width;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                for (int i = 0; i < 5; ++i) {
                    Icon icon = styleSet.getStyle(i).getLegendIcon();
                    icon.paintIcon(c, g, x, y);
                    x += 5 + icon.getIconWidth();
                }
            }
        };
    }

    public static StyleSet lines(String name) {
        return MarkStyles.lines(name, Styles.COLORS);
    }

    public static StyleSet lines(final String name, final Color[] colors) {
        return new StyleSet(){

            public String getName() {
                return name;
            }

            public Style getStyle(int index) {
                Color color = colors[Math.abs(index) % colors.length];
                MarkStyle style = MarkShape.POINT.getStyle(color, 1);
                style.setLine(MarkStyle.DOT_TO_DOT);
                style.setHidePoints(true);
                return style;
            }
        };
    }

    public static StyleSet dashedLines(final String name) {
        final float[][] dashes = Styles.DASHES;
        return new StyleSet(){

            public String getName() {
                return name;
            }

            public Style getStyle(int index) {
                MarkStyle style = MarkShape.POINT.getStyle(Color.BLACK, 1);
                style.setLine(MarkStyle.DOT_TO_DOT);
                style.setHidePoints(true);
                style.setDash(dashes[Math.abs(index) % dashes.length]);
                return style;
            }
        };
    }
}

