/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jibble.epsgraphics.EpsGraphics2D;
import uk.ac.starlink.ttools.plot.DataBounds;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotEvent;
import uk.ac.starlink.ttools.plot.PlotListener;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Range;

public abstract class TablePlot
extends JComponent {
    private final List plotListeners_ = new ArrayList();
    private PlotState state_;

    protected TablePlot() {
    }

    public void setState(PlotState state) {
        this.state_ = state;
    }

    public PlotState getState() {
        return this.state_;
    }

    public void addPlotListener(PlotListener listener) {
        this.plotListeners_.add(listener);
    }

    public void removePlotListener(PlotListener listener) {
        this.plotListeners_.remove(listener);
    }

    private void firePlotChanged(PlotEvent evt) {
        Iterator it = this.plotListeners_.iterator();
        while (it.hasNext()) {
            ((PlotListener)it.next()).plotChanged(evt);
        }
    }

    protected void firePlotChangedLater(final PlotEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TablePlot.this.firePlotChanged(evt);
            }
        });
    }

    public DataBounds calculateBounds(PlotData data, PlotState state) {
        boolean hasErrors = data.getNerror() > 0;
        int ndim = data.getNdim();
        int mainNdim = state.getMainNdim();
        int nset = data.getSetCount();
        Range[] ranges = new Range[ndim];
        for (int idim = 0; idim < ndim; ++idim) {
            ranges[idim] = new Range();
        }
        int[] npoints = new int[nset];
        PointSequence pseq = data.getPointSequence();
        int ip = 0;
        while (pseq.next()) {
            double[] coords = pseq.getPoint();
            boolean isValid = true;
            for (int idim = 0; idim < mainNdim && isValid; ++idim) {
                isValid = isValid && !Double.isNaN(coords[idim]) && !Double.isInfinite(coords[idim]);
            }
            if (!isValid) continue;
            boolean isUsed = false;
            for (int iset = 0; iset < nset; ++iset) {
                if (!pseq.isIncluded(iset)) continue;
                int n = iset;
                npoints[n] = npoints[n] + 1;
                isUsed = true;
            }
            if (!isUsed) continue;
            for (int idim = 0; idim < ndim; ++idim) {
                ranges[idim].submit(coords[idim]);
            }
            if (hasErrors) {
                double[][] errs = pseq.getErrors();
                for (int ierr = 0; ierr < errs.length; ++ierr) {
                    double[] err = errs[ierr];
                    if (err == null) continue;
                    for (int idim = 0; idim < mainNdim; ++idim) {
                        ranges[idim].submit(err[idim]);
                    }
                }
            }
            ++ip;
        }
        pseq.close();
        return new DataBounds(ranges, ip, npoints);
    }

    public abstract Rectangle getPlotBounds();

    public static boolean isVectorContext(Graphics g) {
        return g instanceof EpsGraphics2D || g instanceof Graphics2D && ((Graphics2D)g).getDeviceConfiguration().getDevice().getType() == 1;
    }
}

