/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import gnu.jel.CompilationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.DataBounds;
import uk.ac.starlink.ttools.plot.MarkShape;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.MultiPlotData;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.SubsetSelectionPlotData;
import uk.ac.starlink.ttools.plot.TablePlot;
import uk.ac.starlink.ttools.plot.WrapperPlotData;
import uk.ac.starlink.ttools.plottask.CartesianTablePlotData;
import uk.ac.starlink.ttools.plottask.MarkStyleFactory;
import uk.ac.starlink.ttools.plottask.ShaderParameter;
import uk.ac.starlink.ttools.plottask.StyleFactory;
import uk.ac.starlink.ttools.plottask.TablePlotData;
import uk.ac.starlink.ttools.task.ConsumerTask;
import uk.ac.starlink.ttools.task.DefaultMultiParameter;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.TableProducer;

public class PlotStateFactory {
    public static final String TABLE_VARIABLE = "N";
    public static final String SUBSET_VARIABLE = "S";
    public static final String AUX_VARIABLE = "";
    private static final String TABLE_PREFIX = "in";
    private static final String FILTER_PREFIX = "cmd";
    private static final String SUBSET_PREFIX = "subset";
    private static final String AUX_PREFIX = "aux";
    private static final String STYLE_PREFIX = "";
    private static final double PAD_RATIO = 0.02;
    private final String[] mainDimNames_;
    private final boolean useAux_;
    private final boolean useLabel_;
    private final int errNdim_;
    private final BooleanParameter gridParam_;
    private final DefaultMultiParameter seqParam_;
    private final BooleanParameter aaParam_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PlotStateFactory(String[] dimNames, boolean useAux, boolean useLabel, int errNdim) {
        this.mainDimNames_ = dimNames;
        this.useAux_ = useAux;
        this.useLabel_ = useLabel;
        this.errNdim_ = errNdim;
        this.gridParam_ = new BooleanParameter("grid");
        this.gridParam_.setPrompt("Draw grid lines?");
        this.gridParam_.setDescription(new String[]{"<p>If true, grid lines are drawn on the plot.", "If false, they are absent.", "</p>"});
        this.gridParam_.setDefault(true);
        this.seqParam_ = new DefaultMultiParameter("sequence", ',');
        this.seqParam_.setPrompt("Defines plot order of subsets");
        this.seqParam_.setUsage("<suffix>,<suffix>,...");
        this.seqParam_.setDescription(new String[]{"<p>Can be used to control the sequence in which different", "datasets and subsets are plotted.", "This will affect which symbols are plotted on top of,", "and so potentially obscure,", "which other ones.", "The value of this parameter is a comma-separated list of the", "\"<code>NS</code>\"", "suffixes which appear on the", "parameters which apply to subsets.", "The sets which are named", "will be plotted in order, so the first-named one will be", "at the bottom (most likely to be obscured).", "Note that if this parameter is supplied, then only those sets", "which are named will be plotted,", "so this parameter may also be used to restrict which plots appear", "(though it may not be the most efficient way of doing this).", "If no explicit value is supplied for this parameter,", "sets will be plotted in some sequence decided by STILTS", "(probably alphabetic by suffix).", "</p>"});
        this.seqParam_.setNullPermitted(true);
        this.aaParam_ = new BooleanParameter("antialias");
        this.aaParam_.setPrompt("Use antialiasing for lines?");
        this.aaParam_.setDescription(new String[]{"<p>Controls whether lines are drawn using antialiasing,", "where applicable.", "If lines are drawn to a bitmapped-type graphics output format", "setting this parameter to true smooths the lines out by", "using gradations of colour for diagonal lines, and setting it", "false simply sets each pixel in the line to on or off.", "For vector-type graphics output formats, or for cases in which", "no diagonal lines are drawn, the setting of this parameter", "has no effect.", "Setting it true may slow the plot down slightly.", "</p>"});
        this.aaParam_.setDefault(true);
    }

    public Parameter[] getParameters() {
        String tSuffix = TABLE_VARIABLE;
        String stSuffix = "NS";
        String auxAxName = AUX_PREFIX;
        InputTableParameter inParam = this.createTableParameter(tSuffix);
        FilterParameter filterParam = this.createFilterParameter(tSuffix);
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add((Object)inParam);
        paramList.add(inParam.getFormatParameter());
        paramList.add(inParam.getStreamParameter());
        paramList.add(filterParam);
        ArrayList<AxisParameterSet> axParamSetList = new ArrayList<AxisParameterSet>();
        for (int idim = 0; idim < this.mainDimNames_.length; ++idim) {
            axParamSetList.add(new AxisParameterSet(this.mainDimNames_[idim]));
        }
        if (this.useAux_) {
            axParamSetList.add(new AxisParameterSet(auxAxName));
        }
        AxisParameterSet[] axParamSets = axParamSetList.toArray(new AxisParameterSet[0]);
        int allNdim = axParamSets.length;
        Parameter[][] axScalarParams = new Parameter[allNdim][];
        for (int idim = 0; idim < allNdim; ++idim) {
            AxisParameterSet axParamSet = axParamSets[idim];
            paramList.add(axParamSet.createCoordParameter(tSuffix));
            axScalarParams[idim] = axParamSet.getScalarParameters();
        }
        int nScalarParam = axScalarParams[0].length;
        for (int ip = 0; ip < nScalarParam; ++ip) {
            for (int idim = 0; idim < allNdim; ++idim) {
                paramList.add(axScalarParams[idim][ip]);
            }
        }
        for (int idim = 0; idim < this.errNdim_; ++idim) {
            paramList.add(this.createErrorParameter(this.mainDimNames_[idim], tSuffix));
        }
        if (this.useAux_) {
            ShaderParameter shaderParam = this.createShaderParameters(new String[]{""})[0];
            if (!$assertionsDisabled && shaderParam.getDefault() == null) {
                throw new AssertionError();
            }
            paramList.add((Object)shaderParam);
        }
        if (this.useLabel_) {
            paramList.add(this.createLabelParameter(tSuffix));
        }
        paramList.add(this.createSubsetExpressionParameter(stSuffix));
        paramList.add(this.createSubsetNameParameter(stSuffix));
        paramList.addAll(Arrays.asList(this.createStyleFactory("").getParameters(stSuffix)));
        paramList.add(this.gridParam_);
        paramList.add(this.aaParam_);
        paramList.add((Object)this.seqParam_);
        return paramList.toArray(new Parameter[0]);
    }

    public PlotState getPlotState(Environment env) throws TaskException {
        PlotState state = this.createPlotState();
        this.configurePlotState(state, env);
        return state;
    }

    protected PlotState createPlotState() {
        return new PlotState();
    }

    protected void configurePlotState(PlotState state, Environment env) throws TaskException {
        Object[] auxLabels;
        int mainNdim = this.mainDimNames_.length;
        state.setMainNdim(mainNdim);
        String[] paramNames = env.getNames();
        String tPrefix = TABLE_PREFIX;
        Object[] tableLabels = PlotStateFactory.getSuffixes(paramNames, tPrefix);
        if (tableLabels.length == 0) {
            tableLabels = new String[]{""};
        }
        Arrays.sort(tableLabels);
        int nTable = tableLabels.length;
        ArrayList<String> axNameList = new ArrayList<String>();
        axNameList.addAll(Arrays.asList(this.mainDimNames_));
        if (this.useAux_) {
            auxLabels = AxisParameterSet.getAuxAxisNames(paramNames);
            Arrays.sort(auxLabels);
            for (int ia = 0; ia < auxLabels.length; ++ia) {
                axNameList.add(AUX_PREFIX + (String)auxLabels[ia]);
            }
        } else {
            auxLabels = new String[]{};
        }
        String[] allAxNames = axNameList.toArray(new String[0]);
        int allNdim = allAxNames.length;
        AxisParameterSet[] axParamSets = new AxisParameterSet[allNdim];
        for (int idim = 0; idim < allNdim; ++idim) {
            axParamSets[idim] = new AxisParameterSet(allAxNames[idim]);
        }
        PlotData[] datas = new PlotData[nTable];
        String[] coordExprs0 = null;
        StyleFactory styleFactory = this.createStyleFactory("");
        ArrayList<String> setLabelList = new ArrayList<String>();
        for (int itab = 0; itab < nTable; ++itab) {
            Object tlabel = tableLabels[itab];
            StarTable table = this.getInputTable(env, (String)tlabel);
            String[] coordExprs = new String[allNdim];
            for (int idim = 0; idim < allNdim; ++idim) {
                Parameter coordParam = axParamSets[idim].createCoordParameter((String)tlabel);
                if (idim >= mainNdim) {
                    coordParam.setNullPermitted(true);
                }
                coordExprs[idim] = coordParam.stringValue(env);
            }
            String[] errExprs = new String[this.errNdim_];
            for (int idim = 0; idim < this.errNdim_; ++idim) {
                errExprs[idim] = this.createErrorParameter(this.mainDimNames_[idim], (String)tlabel).stringValue(env);
            }
            String labelExpr = this.useLabel_ ? this.createLabelParameter((String)tlabel).stringValue(env) : null;
            SubsetDef[] subsetDefs = this.getSubsetDefinitions(env, (String)tlabel, styleFactory);
            int nset = subsetDefs.length;
            String[] setExprs = new String[nset];
            String[] setNames = new String[nset];
            Style[] setStyles = new Style[nset];
            for (int is = 0; is < nset; ++is) {
                SubsetDef sdef = subsetDefs[is];
                setLabelList.add(sdef.label_);
                setExprs[is] = sdef.expression_;
                setNames[is] = sdef.name_;
                setStyles[is] = sdef.style_;
            }
            try {
                TablePlotData plotData = this.createPlotData(env, (String)tlabel, table, setExprs, setNames, setStyles, labelExpr, coordExprs, errExprs);
                plotData.checkExpressions();
                datas[itab] = plotData;
            }
            catch (CompilationException e) {
                throw new TaskException(e.getMessage(), (Throwable)e);
            }
            if (itab != 0) continue;
            coordExprs0 = coordExprs;
        }
        PlotData plotData = new MultiPlotData(datas);
        StringBuffer seqbuf = new StringBuffer();
        Iterator it = setLabelList.iterator();
        while (it.hasNext()) {
            seqbuf.append(it.next());
            if (!it.hasNext()) continue;
            seqbuf.append(this.seqParam_.getValueSeparator());
        }
        String seqDefault = seqbuf.toString();
        this.seqParam_.setDefault(seqDefault);
        String seqString = this.seqParam_.stringValue(env);
        if (seqString != null && !seqString.equals(seqDefault)) {
            String[] setLabels = this.seqParam_.stringValue(env).split("\\Q" + this.seqParam_.getValueSeparator() + "\\E");
            int nset = setLabels.length;
            for (int is = 0; is < nset; ++is) {
                setLabels[is] = setLabels[is].trim();
            }
            int[] isets = new int[nset];
            for (int is = 0; is < nset; ++is) {
                String label = setLabels[is];
                isets[is] = setLabelList.indexOf(label);
                if (isets[is] >= 0) continue;
                String msg = "Unknown set identifier \"" + label + "\"; " + "known labels are " + setLabelList;
                throw new ParameterValueException((Parameter)this.seqParam_, msg);
            }
            plotData = new SubsetSelectionPlotData(plotData, isets);
        }
        state.setPlotData(plotData);
        boolean[] logFlags = new boolean[allNdim];
        boolean[] flipFlags = new boolean[allNdim];
        double[][] ranges = new double[allNdim][];
        String[] labels = new String[allNdim];
        for (int idim = 0; idim < allNdim; ++idim) {
            AxisParameterSet axParamSet = axParamSets[idim];
            logFlags[idim] = axParamSet.logParam_.booleanValue(env);
            flipFlags[idim] = axParamSet.flipParam_.booleanValue(env);
            ranges[idim] = new double[]{axParamSet.loParam_.doubleValue(env), axParamSet.hiParam_.doubleValue(env)};
            String labelDefault = coordExprs0[idim];
            if (labelDefault == null || labelDefault.trim().length() == 0) {
                labelDefault = idim < mainNdim ? this.mainDimNames_[idim] : "Aux " + (idim - mainNdim + 1);
            }
            axParamSet.labelParam_.setDefault(labelDefault);
            labels[idim] = axParamSet.labelParam_.stringValue(env);
        }
        state.setLogFlags(logFlags);
        state.setFlipFlags(flipFlags);
        state.setRanges(ranges);
        state.setAxisLabels(labels);
        Shader[] shaders = new Shader[auxLabels.length];
        ShaderParameter[] shaderParams = this.createShaderParameters((String[])auxLabels);
        for (int ia = 0; ia < auxLabels.length; ++ia) {
            shaders[ia] = shaderParams[ia].shaderValue(env);
        }
        state.setShaders(shaders);
        state.setGrid(this.gridParam_.booleanValue(env));
        state.setAntialias(this.aaParam_.booleanValue(env));
    }

    protected TablePlotData createPlotData(Environment env, String tLabel, StarTable table, String[] setExprs, String[] setNames, Style[] setStyles, String labelExpr, String[] coordExprs, String[] errExprs) throws TaskException, CompilationException {
        return new CartesianTablePlotData(table, setExprs, setNames, setStyles, labelExpr, coordExprs, errExprs);
    }

    public void configureFromData(PlotState state, TablePlot plot) throws TaskException, IOException {
        if (this.requiresConfigureFromBounds(state)) {
            this.configureFromBounds(state, this.calculateBounds(state, plot));
        }
    }

    public DataBounds calculateBounds(PlotState state, TablePlot plot) {
        return plot.calculateBounds(state.getPlotData(), state);
    }

    protected boolean requiresConfigureFromBounds(PlotState state) {
        PlotData plotData = state.getPlotData();
        int ndim = plotData.getNdim();
        for (int idim = 0; idim < ndim; ++idim) {
            double[] range = state.getRanges()[idim];
            if (!Double.isNaN(range[0]) && !Double.isNaN(range[1])) continue;
            return true;
        }
        int nset = plotData.getSetCount();
        for (int is = 0; is < nset; ++is) {
            if (!this.requiresAdjustFromData(plotData.getSetStyle(is))) continue;
            return true;
        }
        return false;
    }

    protected void configureFromBounds(PlotState state, DataBounds bounds) throws TaskException {
        PlotData plotData = state.getPlotData();
        int ndim = bounds.getRanges().length;
        int mainNdim = this.mainDimNames_.length;
        for (int idim = 0; idim < ndim; ++idim) {
            String dimName;
            boolean logFlag = state.getLogFlags()[idim];
            double[] stateRange = state.getRanges()[idim];
            double[] calcRange = bounds.getRanges()[idim].getFiniteBounds(logFlag);
            boolean loCalc = Double.isNaN(stateRange[0]);
            boolean hiCalc = Double.isNaN(stateRange[1]);
            String string = dimName = idim < mainNdim ? this.mainDimNames_[idim] : "Aux";
            if (loCalc) {
                if (!hiCalc && stateRange[1] <= calcRange[0]) {
                    String msg = "Supplied " + dimName + " upper bound (" + stateRange[1] + ") is less than data lower bound (" + calcRange[0] + ")";
                    throw new ExecutionException(msg);
                }
                stateRange[0] = calcRange[0];
            }
            if (hiCalc) {
                if (!loCalc && stateRange[0] >= calcRange[1]) {
                    String msg = "Supplied " + dimName + " lower bound (" + stateRange[0] + ") is greater than data upper bound (" + calcRange[1] + ")";
                    throw new ExecutionException(msg);
                }
                stateRange[1] = calcRange[1];
            }
            if (!$assertionsDisabled && !(stateRange[0] <= stateRange[1])) {
                throw new AssertionError();
            }
            if (stateRange[0] == stateRange[1]) {
                double val = stateRange[0];
                if (val == Math.floor(val)) {
                    stateRange[0] = stateRange[0] - 1.0;
                    stateRange[1] = stateRange[1] + 1.0;
                } else {
                    stateRange[0] = Math.floor(val);
                    stateRange[1] = Math.ceil(val);
                }
            } else if (idim < mainNdim) {
                double pad;
                if (logFlag) {
                    pad = Math.pow(stateRange[1] / stateRange[0], 0.02);
                    if (loCalc) {
                        stateRange[0] = stateRange[0] / pad;
                    }
                    if (hiCalc) {
                        stateRange[1] = stateRange[1] * pad;
                    }
                } else {
                    pad = (stateRange[1] - stateRange[0]) * 0.02;
                    if (loCalc) {
                        stateRange[0] = stateRange[0] - pad;
                    }
                    if (hiCalc) {
                        stateRange[1] = stateRange[1] + pad;
                    }
                }
            }
            if (!$assertionsDisabled && !(state.getRanges()[idim][0] < state.getRanges()[idim][1])) {
                throw new AssertionError();
            }
        }
        int nset = plotData.getSetCount();
        final Style[] styles = new Style[nset];
        int nAdjust = 0;
        for (int is = 0; is < nset; ++is) {
            Style style = plotData.getSetStyle(is);
            if (this.requiresAdjustFromData(style)) {
                styles[is] = this.adjustFromData(style, is, bounds);
                ++nAdjust;
                continue;
            }
            styles[is] = style;
        }
        if (nAdjust > 0) {
            state.setPlotData(new WrapperPlotData(plotData){

                public Style getSetStyle(int is) {
                    return styles[is];
                }
            });
        }
    }

    public boolean requiresAdjustFromData(Style style) {
        MarkStyle mstyle;
        return style instanceof MarkStyle && (mstyle = (MarkStyle)style).getSize() < 0;
    }

    public Style adjustFromData(Style style, int iset, DataBounds bounds) {
        int npoint = bounds.getPointCounts()[iset];
        if (style instanceof MarkStyle) {
            MarkStyle mstyle = (MarkStyle)style;
            if (mstyle.getSize() < 0) {
                int size;
                if (npoint > 100000) {
                    size = 0;
                    if (mstyle.getOpaqueLimit() == 1) {
                        mstyle.setOpaqueLimit(npoint / 5000);
                    }
                } else {
                    size = npoint > 10000 ? 0 : (npoint > 2000 ? 1 : (npoint > 200 ? 2 : (npoint > 20 ? 3 : 4)));
                }
                if (size != mstyle.getSize()) {
                    MarkShape shape = size > 0 ? mstyle.getShapeId() : MarkShape.POINT;
                    MarkStyle style1 = shape.getStyle(mstyle.getColor(), size);
                    style1.setLine(mstyle.getLine());
                    style1.setLineWidth(mstyle.getLineWidth());
                    style1.setDash(mstyle.getDash());
                    style1.setHidePoints(mstyle.getHidePoints());
                    style1.setOpaqueLimit(mstyle.getOpaqueLimit());
                    style1.setErrorRenderer(mstyle.getErrorRenderer());
                    mstyle = style1;
                }
            }
            return mstyle;
        }
        return style;
    }

    protected StyleFactory createStyleFactory(String prefix) {
        return new MarkStyleFactory(prefix, this.errNdim_);
    }

    private StarTable getInputTable(Environment env, String tlabel) throws TaskException {
        TableProducer producer = ConsumerTask.createProducer(env, this.createFilterParameter(tlabel), this.createTableParameter(tlabel));
        try {
            return producer.getTable();
        }
        catch (IOException e) {
            throw new ExecutionException("Table processing error", (Throwable)e);
        }
    }

    private SubsetDef[] getSubsetDefinitions(Environment env, String tlabel, StyleFactory styleFactory) throws TaskException {
        String[] paramNames = env.getNames();
        String stPrefix = SUBSET_PREFIX + tlabel;
        Object[] subLabels = PlotStateFactory.getSuffixes(paramNames, stPrefix);
        Arrays.sort(subLabels);
        int nset = subLabels.length;
        if (nset == 0) {
            Parameter nameParam = this.createSubsetNameParameter(tlabel);
            nameParam.setDefault(tlabel);
            String name = nameParam.stringValue(env);
            return new SubsetDef[]{new SubsetDef(tlabel, "true", name, styleFactory.getStyle(env, tlabel))};
        }
        SubsetDef[] sdefs = new SubsetDef[nset];
        for (int is = 0; is < nset; ++is) {
            String stLabel = tlabel + (String)subLabels[is];
            String expr = this.createSubsetExpressionParameter(stLabel).stringValue(env);
            Parameter nameParam = this.createSubsetNameParameter(stLabel);
            nameParam.setDefault(expr);
            String name = nameParam.stringValue(env);
            sdefs[is] = new SubsetDef(stLabel, expr, name, styleFactory.getStyle(env, stLabel));
        }
        return sdefs;
    }

    private InputTableParameter createTableParameter(String tlabel) {
        return new InputTableParameter(TABLE_PREFIX + tlabel);
    }

    private FilterParameter createFilterParameter(String tlabel) {
        return new FilterParameter(FILTER_PREFIX + tlabel);
    }

    private Parameter createErrorParameter(String axName, String tlabel) {
        Parameter param = new Parameter(axName.toLowerCase() + "error" + tlabel);
        param.setUsage("<expr>|[<lo-expr>],[<hi-expr>]");
        param.setPrompt("Error bound(s) in " + axName + " for table " + tlabel);
        param.setNullPermitted(true);
        param.setDescription(new String[]{"<p>Gives expressions for the errors on " + axName, "coordinates for table " + tlabel + ".", "The following forms are permitted:", "<ul>", "<li><code>&lt;expr&gt;</code>: symmetric error value</li>", "<li><code>&lt;lo-expr&gt;,&lt;hi-expr&gt;</code>:distinct lower and upper error values</li>", "<li><code>&lt;lo-expr&gt;,</code>: lower error value only</li>", "<li><code>,&lt;hi-expr&gt;</code>: upper error value only</li>", "<li><code>null</code>: no errors</li>", "</ul>", "The expression in each case is a numeric algebraic expression", "based on column names", "as described in <ref id='jel'/>.", "</p>"});
        return param;
    }

    private Parameter createLabelParameter(String tlabel) {
        Parameter labelParam = new Parameter("txtlabel" + tlabel);
        labelParam.setPrompt("Label annotating each plotted point");
        labelParam.setDescription(new String[]{"<p>Gives an expression which will label each plotted point.", "If given, the text (or number) resulting from evaluating", "the expression will be written near each point which is", "plotted.", "</p>"});
        labelParam.setNullPermitted(true);
        return labelParam;
    }

    private Parameter createSubsetExpressionParameter(String stlabel) {
        Parameter param = new Parameter(SUBSET_PREFIX + stlabel);
        param.setPrompt("Selection criterion for subset " + stlabel);
        param.setDescription(new String[]{"<p>Gives the selection criterion for the subset labelled", "\"<code>" + stlabel + "</code>\".", "This is a boolean expression which may be the name of", "a boolean-valued column or any other boolean-valued expression.", "Rows for which the expression evaluates true will be included", "in the subset, and those for which it evaluates false will not.", "</p>"});
        param.setUsage("<expr>");
        return param;
    }

    private Parameter createSubsetNameParameter(String stlabel) {
        Parameter nameParam = new Parameter("name" + stlabel);
        nameParam.setNullPermitted(true);
        nameParam.setPrompt("Label for subset " + stlabel);
        nameParam.setDescription(new String[]{"<p>Provides a name to use for a subset with the symbolic label", stlabel + ".", "This name will be used for display in the legend,", "if one is displayed.", "</p>"});
        return nameParam;
    }

    private ShaderParameter[] createShaderParameters(String[] auxlabels) {
        int nparam = auxlabels.length;
        ShaderParameter[] params = new ShaderParameter[nparam];
        String[] dflts = ShaderParameter.getDefaultValues(nparam);
        for (int i = 0; i < nparam; ++i) {
            params[i] = new ShaderParameter(AUX_PREFIX + auxlabels[i] + "shader");
            params[i].setDefault(dflts[i]);
        }
        return params;
    }

    private static String[] getSuffixes(String[] names, String prefix) {
        ArrayList<String> suffixList = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            String suffix;
            if (!names[i].toLowerCase().startsWith(prefix.toLowerCase()) || suffixList.contains(suffix = names[i].substring(prefix.length()))) continue;
            suffixList.add(suffix);
        }
        return suffixList.toArray(new String[0]);
    }

    static {
        $assertionsDisabled = !PlotStateFactory.class.desiredAssertionStatus();
    }

    private static class SubsetDef {
        final String label_;
        final String expression_;
        final String name_;
        final Style style_;

        SubsetDef(String label, String expression, String name, Style style) {
            this.label_ = label;
            this.expression_ = expression;
            this.name_ = name;
            this.style_ = style;
        }
    }

    private static class AxisParameterSet {
        final String axName_;
        final DoubleParameter loParam_;
        final DoubleParameter hiParam_;
        final BooleanParameter logParam_;
        final BooleanParameter flipParam_;
        final Parameter labelParam_;
        private static Pattern auxAxisRegex_;

        public AxisParameterSet(String axName) {
            this.axName_ = axName.toLowerCase();
            this.loParam_ = new DoubleParameter(this.axName_ + "lo");
            this.loParam_.setPrompt("Lower bound for " + this.axName_ + " axis");
            this.loParam_.setDescription(new String[]{"<p>The lower limit for the plotted " + this.axName_ + " axis.", "If not set, a value will be chosen which is low enough", "to accommodate all the data.", "</p>"});
            this.loParam_.setNullPermitted(true);
            this.hiParam_ = new DoubleParameter(this.axName_ + "hi");
            this.hiParam_.setPrompt("Upper bound for " + this.axName_ + " axis");
            this.hiParam_.setDescription(new String[]{"<p>The upper limit for the plotted " + this.axName_ + " axis.", "If not set, a value will be chosen which is high enough", "to accommodate all the data.", "</p>"});
            this.hiParam_.setNullPermitted(true);
            this.logParam_ = new BooleanParameter(this.axName_ + "log");
            this.logParam_.setPrompt("Logarithmic scale on " + this.axName_ + " axis?");
            this.logParam_.setDescription(new String[]{"<p>If false (the default), the scale on the " + this.axName_, "axis is linear; if true it is logarithmic.", "</p>"});
            this.logParam_.setDefault("false");
            this.flipParam_ = new BooleanParameter(this.axName_ + "flip");
            this.flipParam_.setPrompt("Reversed direction on " + this.axName_ + "axis?");
            this.flipParam_.setDescription(new String[]{"<p>If set true, the scale on the " + this.axName_ + " axis", "will increase in the opposite sense from usual", "(e.g. right to left rather than left to right).", "</p>"});
            this.flipParam_.setDefault("false");
            this.labelParam_ = new Parameter(this.axName_ + "label");
            this.labelParam_.setPrompt("Label for axis " + this.axName_);
            this.labelParam_.setDescription(new String[]{"<p>Specifies a label to be used for annotating axis " + this.axName_ + ".", "A default values based on the plotted data will be used", "if no value is supplied for this parameter.", "</p>"});
            this.labelParam_.setNullPermitted(true);
        }

        public Parameter[] getScalarParameters() {
            return new Parameter[]{this.loParam_, this.hiParam_, this.logParam_, this.flipParam_, this.labelParam_};
        }

        public Parameter createCoordParameter(String tlabel) {
            Parameter param = new Parameter(this.axName_ + "data" + tlabel);
            param.setUsage("<expr>");
            param.setPrompt("Value to plot on " + this.axName_ + " axis" + " for table " + tlabel);
            param.setDescription(new String[]{"<p>Gives a column name or expression for the " + this.axName_, "axis data for table " + tlabel + ".", "The expression is a numeric algebraic expression", "based on column names", "as described in <ref id=\"jel\"/>", "</p>"});
            return param;
        }

        private static Pattern getAuxAxisRegex() {
            if (auxAxisRegex_ == null) {
                AxisParameterSet paramSet = new AxisParameterSet("");
                ArrayList<String> nameList = new ArrayList<String>();
                nameList.add(paramSet.createCoordParameter("").getName());
                Parameter[] scalarParams = paramSet.getScalarParameters();
                for (int ip = 0; ip < scalarParams.length; ++ip) {
                    nameList.add(scalarParams[ip].getName());
                }
                StringBuffer sbuf = new StringBuffer().append("\\Q").append(PlotStateFactory.AUX_PREFIX).append("\\E").append('(').append(".*").append(')').append('(');
                Iterator it = nameList.iterator();
                while (it.hasNext()) {
                    String baseName = (String)it.next();
                    sbuf.append("\\Q").append(baseName).append("\\E");
                    if (!it.hasNext()) continue;
                    sbuf.append('|');
                }
                sbuf.append(')').append(".*");
                auxAxisRegex_ = Pattern.compile(sbuf.toString(), 2);
            }
            return auxAxisRegex_;
        }

        public static String[] getAuxAxisNames(String[] paramNames) {
            Pattern regex = AxisParameterSet.getAuxAxisRegex();
            HashSet<String> auxNameSet = new HashSet<String>();
            for (int in = 0; in < paramNames.length; ++in) {
                Matcher matcher = regex.matcher(paramNames[in]);
                if (!matcher.matches()) continue;
                auxNameSet.add(matcher.group(1));
            }
            return auxNameSet.toArray(new String[0]);
        }
    }
}

