/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import jsky.util.ConnectionUtil;
import jsky.util.StatusLogger;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressBarUtil;
import jsky.util.gui.ProgressException;

public class StatusPanel
extends JPanel
implements StatusLogger,
SwingConstants {
    ProgressBarUtil progressBar;
    JTextField textField;
    ConnectionUtil connectionUtil;

    public StatusPanel(String barPosition, String textPosition) {
        this.setLayout(new BorderLayout());
        this.progressBar = new ProgressBarUtil();
        this.progressBar.setToolTipText("Download progress");
        this.progressBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.progressBar, barPosition);
        if (barPosition.equals("North") || barPosition.equals("South")) {
            Dimension d = this.progressBar.getPreferredSize();
            d.height -= 4;
            this.progressBar.setPreferredSize(d);
        }
        this.textField = new JTextField(0);
        this.textField.setEditable(false);
        this.textField.setToolTipText("Progress messages");
        this.add((Component)this.textField, textPosition);
        this.textField.setBackground(this.getBackground());
        this.textField.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public StatusPanel() {
        this("West", "Center");
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public ProgressBarUtil getProgressBar() {
        return this.progressBar;
    }

    public void setText(final String s) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusPanel.this.setText(s);
                }
            });
            return;
        }
        this.textField.setText(s);
        this.textField.setCaretPosition(0);
        this.textField.setScrollOffset(0);
    }

    @Override
    public void logMessage(final String msg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusPanel.this.logMessage(msg);
                }
            });
            return;
        }
        this.setText(msg);
    }

    @Override
    public void setProgress(final int percent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusPanel.this.setProgress(percent);
                }
            });
            return;
        }
        this.progressBar.setValue(percent);
        if (percent <= 0) {
            this.progressBar.setStringPainted(false);
        } else {
            this.progressBar.setStringPainted(true);
        }
    }

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        URLConnection connection;
        String host = url.getHost();
        if (host != null && host.length() != 0) {
            this.logMessage("Connect: " + host + ", waiting for reply.");
            this.connectionUtil = new ConnectionUtil(url);
            connection = this.connectionUtil.openConnection();
            this.logMessage("Connected to " + host);
        } else {
            connection = url.openConnection();
        }
        return connection;
    }

    @Override
    public ProgressBarFilterInputStream getLoggedInputStream(InputStream in, int size) {
        return new ProgressBarFilterInputStream(this.progressBar, this.textField, in, size);
    }

    @Override
    public ProgressBarFilterInputStream getLoggedInputStream(URL url) {
        return new ProgressBarFilterInputStream(this.progressBar, this.textField, url);
    }

    @Override
    public void stopLoggingInputStream(ProgressBarFilterInputStream in) throws IOException {
        in.close();
        if (in.isInterrupted()) {
            throw new ProgressException("Reading was interrupted");
        }
    }

    public void interrupt() {
        if (this.connectionUtil != null) {
            this.connectionUtil.interrupt();
            this.connectionUtil = null;
        }
    }
}

