/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.GridBagUtil;

public class XYDisplay
extends JPanel {
    protected JLabel xLabel;
    protected JLabel yLabel;
    protected JTextField xValue;
    protected JTextField yValue;

    public XYDisplay(String xLabelStr, String yLabelStr) {
        this.setLayout(new GridBagLayout());
        GridBagUtil layoutUtil = new GridBagUtil(this, (GridBagLayout)this.getLayout());
        this.xLabel = new JLabel(xLabelStr);
        this.yLabel = new JLabel(yLabelStr);
        this.xValue = new JTextField();
        this.yValue = new JTextField();
        this.setupLabel(this.xLabel);
        this.setupLabel(this.yLabel);
        this.setupTextField(this.xValue);
        this.setupTextField(this.yValue);
        layoutUtil.add(this.xLabel, 0, 0, 1, 1, 0.0, 0.0, 2, 13);
        layoutUtil.add(this.xValue, 1, 0, 1, 1, 1.0, 0.0, 2, 17);
        layoutUtil.add(this.yLabel, 0, 1, 1, 1, 0.0, 0.0, 2, 13);
        layoutUtil.add(this.yValue, 1, 1, 1, 1, 1.0, 0.0, 2, 17);
    }

    protected void setupLabel(JLabel l) {
        l.setForeground(Color.black);
        l.setFont(l.getFont().deriveFont(0));
    }

    protected void setupTextField(JTextField t) {
        t.setEnabled(false);
        t.setDisabledTextColor(Color.black);
        t.setBackground(this.getBackground());
        t.setBorder(new BevelBorder(1));
    }

    public void setValueWidth(int w) {
        Dimension d = this.xValue.getPreferredSize();
        d.width = w;
        this.xValue.setPreferredSize(d);
        this.yValue.setPreferredSize(d);
    }

    public XYDisplay() {
        this("X", "Y");
    }

    public void setX(String s) {
        this.xValue.setText(s);
    }

    public void setX(double d) {
        this.xValue.setText(String.valueOf(d));
    }

    public void setY(String s) {
        this.yValue.setText(s);
    }

    public void setY(double d) {
        this.yValue.setText(String.valueOf(d));
    }

    public void set(Point2D.Double p) {
        if (p != null) {
            this.xValue.setText(String.valueOf(p.getX()));
            this.yValue.setText(String.valueOf(p.getY()));
        } else {
            this.xValue.setText("");
            this.yValue.setText("");
        }
    }

    public JLabel getXLabel() {
        return this.xLabel;
    }

    public JLabel getYLabel() {
        return this.yLabel;
    }

    public JTextField getXValue() {
        return this.xValue;
    }

    public JTextField getYValue() {
        return this.yValue;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        XYDisplay panel = new XYDisplay();
        panel.setX("99.676");
        panel.setY("22.2");
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }
}

