/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.registry.search;

import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.soap.SOAPException;
import net.ivoa.registry.RegistryAccessException;
import net.ivoa.registry.RegistryCommException;
import net.ivoa.registry.RegistryFormatException;
import net.ivoa.registry.RegistryServiceException;
import net.ivoa.registry.search.ADQLSyntaxException;
import net.ivoa.registry.search.IDNotFoundException;
import net.ivoa.registry.search.Identifiers;
import net.ivoa.registry.search.ParseException;
import net.ivoa.registry.search.Records;
import net.ivoa.registry.search.SOAPSearchClient;
import net.ivoa.registry.search.Searcher;
import net.ivoa.registry.search.ServiceCaller;
import net.ivoa.registry.search.UnsupportedOperationException;
import net.ivoa.registry.search.VOResource;
import net.ivoa.registry.search.Where2DOM;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegistrySearchClient {
    protected int resRecordBuffer = 500;
    protected int resIDBuffer = 10000;
    protected SOAPSearchClient service = null;
    protected short strictness = 1;
    public static URL defaultEndpoint = null;
    public static final short LOOSE_COMPLIANCE = 0;
    public static final short WARN_COMPLIANCE = 1;
    public static final short STRICT_COMPLIANCE = 2;

    public RegistrySearchClient() {
        this(defaultEndpoint);
    }

    public RegistrySearchClient(URL endpointURL) {
        this.service = new SOAPSearchClient(endpointURL, this.strictness);
    }

    public void setCompliance(short level) {
        this.strictness = level;
        this.service.setCompliance(level);
    }

    public short getCompliance() {
        return this.strictness;
    }

    public boolean soapArgsAreQualified() {
        return this.service.argsAreQualified();
    }

    public void qualifySoapArgs(boolean yesno) {
        this.service.qualifyArgs(yesno);
    }

    public int getRecordBufferSize() {
        return this.resRecordBuffer;
    }

    public void setRecordBufferSize(int size) {
        if (size < 1) {
            size = 500;
        }
        this.resRecordBuffer = size;
    }

    public VOResource getIdentity() throws RegistryAccessException {
        try {
            return new VOResource(RegistrySearchClient.getFirstChildElement(this.service.getIdentity()));
        }
        catch (SOAPException ex) {
            throw new RegistryCommException((Exception)((Object)ex));
        }
    }

    private static Element getFirstChildElement(Element parent) throws RegistryFormatException {
        Node child;
        for (child = parent.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        if (child == null) {
            throw new RegistryFormatException("Empty response wrapper: " + parent.getTagName());
        }
        return (Element)child;
    }

    public VOResource getResource(String ivoid) throws IDNotFoundException, RegistryAccessException {
        try {
            return new VOResource(RegistrySearchClient.getFirstChildElement(this.service.getResource(ivoid)));
        }
        catch (SOAPException ex) {
            throw new RegistryCommException((Exception)((Object)ex));
        }
    }

    public Records searchByKeywords(String keywords, boolean orThem) throws RegistryServiceException, RegistryFormatException, RegistryCommException {
        return new Records(new KeywordSearch(this.service, keywords, orThem, 0, this.resRecordBuffer, false), this.strictness);
    }

    public Identifiers identifiersByKeywords(String keywords, boolean orThem) throws RegistryServiceException, RegistryFormatException, RegistryCommException {
        return new Identifiers(new KeywordSearch(this.service, keywords, orThem, 0, this.resRecordBuffer, true), this.strictness);
    }

    public Records searchByADQL(String adqlWhere) throws RegistryServiceException, RegistryFormatException, RegistryCommException, ADQLSyntaxException {
        return new Records(new Search(this.service, adqlWhere, 0, this.resRecordBuffer, false), this.strictness);
    }

    public Identifiers identifiersByADQL(String adqlWhere) throws RegistryServiceException, RegistryFormatException, RegistryCommException, ADQLSyntaxException {
        return new Identifiers(new Search(this.service, adqlWhere, 0, this.resRecordBuffer, true), this.strictness);
    }

    public Element searchByXQuery(String xquery) throws RegistryServiceException, UnsupportedOperationException, RegistryCommException {
        try {
            return this.service.xquerySearch(xquery);
        }
        catch (SOAPException ex) {
            throw new RegistryCommException((Exception)((Object)ex));
        }
    }

    public void setCaller(ServiceCaller c) {
        this.service.setCaller(c);
    }

    private static Method getSearchMethod() {
        try {
            return SOAPSearchClient.class.getMethod("search", Element.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException ex) {
            throw new InternalError("programmer error: can't find search method via reflection");
        }
    }

    Element convertWhere(String adqlwhere) throws ADQLSyntaxException {
        adqlwhere = "where " + adqlwhere.trim();
        Where2DOM p = new Where2DOM(new StringReader(adqlwhere));
        try {
            return p.parseWhere();
        }
        catch (ParseException ex) {
            throw new ADQLSyntaxException(ex);
        }
    }

    private static Method getKeywordSearchMethod() {
        try {
            return SOAPSearchClient.class.getMethod("keywordSearch", String.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException ex) {
            throw new InternalError("programmer error: can't find keywordSearch method via reflection");
        }
    }

    static {
        String hardcoded = "http://nvo.stsci.edu/vor10/ristandardservice.asmx";
        String defURL = System.getProperty("VORegsitry.search.defaultRegistry", hardcoded);
        try {
            defaultEndpoint = new URL(defURL);
        }
        catch (MalformedURLException ex) {
            System.err.println("Malformed default registry URL: " + defURL);
            try {
                defaultEndpoint = new URL(hardcoded);
            }
            catch (MalformedURLException e) {
                throw new InternalError("programmer error: bad hardcoded URL: " + hardcoded);
            }
        }
    }

    class KeywordSearch
    extends Searcher {
        KeywordSearch(SOAPSearchClient service, String keywords, boolean orThem, int from, int max, boolean idsonly) {
            super(service, RegistrySearchClient.getKeywordSearchMethod(), from, max);
            this.args = new Object[]{keywords, new Boolean(orThem), new Integer(from), new Integer(max), new Boolean(idsonly)};
        }

        public void updateArgs() {
            this.args[2] = new Integer(this.getFrom());
            this.args[3] = new Integer(this.getMax());
        }
    }

    class Search
    extends Searcher {
        Search(SOAPSearchClient service, String adqlwhere, int from, int max, boolean idsonly) throws ADQLSyntaxException {
            super(service, RegistrySearchClient.getSearchMethod(), from, max);
            Element where = RegistrySearchClient.this.convertWhere(adqlwhere);
            this.args = new Object[]{where, new Integer(from), new Integer(max), new Boolean(idsonly)};
        }

        public void updateArgs() {
            this.args[1] = new Integer(this.getFrom());
            this.args[2] = new Integer(this.getMax());
        }
    }
}

