/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.serviceshelper;

import alma.ACSErr.Completion;
import alma.acs.commandcenter.serviceshelper.TMCDBServicesHelper;
import alma.acs.container.corba.AcsCorba;
import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.util.AcsLocations;
import alma.acsdaemon.DaemonSequenceCallback;
import alma.acsdaemon.DaemonSequenceCallbackHelper;
import alma.acsdaemon.DaemonSequenceCallbackPOA;
import alma.acsdaemon.ServiceDefinitionBuilder;
import alma.acsdaemon.ServicesDaemon;
import alma.acsdaemon.ServicesDaemonHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.PortableServer.Servant;

public class StartServicesHelper {
    private final Set<ServicesListener> listeners = Collections.synchronizedSet(new HashSet());
    private final Session session;
    private final AcsLogger logger;
    private final String configurationName;
    private final AcsCorba acsCorba;
    private final String daemonHost;
    private final int instance;
    private final ServicesHelperThreadFactory threadFactory = new ServicesHelperThreadFactory("StartServicesHelperThreadGroup");

    public StartServicesHelper(Session session, String configurationName, AcsCorba acsCorba, AcsLogger logger, String daemonHost, int instance) {
        if (session == null) {
            throw new IllegalArgumentException("The name of the configuration can't be null nor empty!");
        }
        this.session = session;
        if (configurationName == null || configurationName.isEmpty()) {
            throw new IllegalArgumentException("The Session can't be NULL nor empty!");
        }
        this.configurationName = configurationName;
        if (acsCorba == null) {
            throw new IllegalArgumentException("The AcsCorba can't be null!");
        }
        this.acsCorba = acsCorba;
        if (logger == null) {
            throw new IllegalArgumentException("The logger can't be null!");
        }
        this.logger = logger;
        if (daemonHost == null || daemonHost.isEmpty()) {
            throw new IllegalArgumentException("The host address of the service daemon can't be NULL nor empty!");
        }
        this.daemonHost = daemonHost;
        this.instance = instance;
        logger.log((Level)AcsLogLevel.DEBUG, "StartServicesHelper instantiated with daemon " + this.daemonHost + ", instance " + this.instance + " and configuration name " + this.configurationName);
    }

    public AlarmServicesDefinitionHolder getServicesDescription() throws GettingDaemonException, DaemonException, TMCDBException {
        ServicesDaemon daemon = this.getServicesDaemon();
        return this.internalGetServicesDescription(daemon);
    }

    private AlarmServicesDefinitionHolder internalGetServicesDescription(ServicesDaemon daemon) throws HibernateException, DaemonException, TMCDBException {
        if (daemon == null) {
            throw new IllegalArgumentException("The daemon can't be null");
        }
        ServiceDefinitionBuilder srvDefBuilder = null;
        try {
            srvDefBuilder = daemon.create_service_definition_builder((short)this.instance);
        }
        catch (Throwable t) {
            throw new DaemonException("Error getting the service definition builder", t);
        }
        this.logger.log((Level)AcsLogLevel.DEBUG, "ServiceDefinitionBuilder got from the ACS services daemon");
        List<TMCDBServicesHelper.AcsServiceToStart> services = this.getServicesList();
        if (services.isEmpty()) {
            throw new TMCDBException("No services to start from TMCDB");
        }
        this.logger.log((Level)AcsLogLevel.DEBUG, "Read " + services.size() + " to start from TMCDB");
        try {
            block14: for (TMCDBServicesHelper.AcsServiceToStart svc : services) {
                if (svc.serviceName == null) {
                    this.logger.log((Level)AcsLogLevel.DEBUG, "Adding " + svc.serviceType + "@" + svc.hostName + " to the ServicesDefinitionBuilder");
                } else {
                    this.logger.log((Level)AcsLogLevel.DEBUG, "Adding " + svc.serviceType + "@" + svc.hostName + " with name " + svc.serviceName + " to the ServicesDefinitionBuilder");
                }
                switch (svc.serviceType) {
                    case MANAGER: {
                        srvDefBuilder.add_manager(svc.hostName, "", false);
                        continue block14;
                    }
                    case ALARM: {
                        srvDefBuilder.add_alarm_service(svc.hostName);
                        continue block14;
                    }
                    case CDB: {
                        srvDefBuilder.add_rdb_cdb(svc.hostName, false, this.configurationName);
                        continue block14;
                    }
                    case IFR: {
                        srvDefBuilder.add_interface_repository(svc.hostName, true, false);
                        continue block14;
                    }
                    case LOGGING: {
                        srvDefBuilder.add_logging_service(svc.hostName, "Log");
                        continue block14;
                    }
                    case LOGPROXY: {
                        srvDefBuilder.add_acs_log(svc.hostName);
                        continue block14;
                    }
                    case NAMING: {
                        srvDefBuilder.add_naming_service(svc.hostName);
                        continue block14;
                    }
                    case NOTIFICATION: {
                        srvDefBuilder.add_notification_service(svc.serviceName, svc.hostName);
                        continue block14;
                    }
                }
                throw new Exception("Unknown type of service to start: " + svc.serviceType + ", on " + svc.hostName);
            }
        }
        catch (Throwable t) {
            throw new DaemonException("Error adding services to the daemon", t);
        }
        this.logger.log((Level)AcsLogLevel.DEBUG, "All the services have been added to the ServiceDefinitionBuilder");
        String svcsXML = srvDefBuilder.get_services_definition();
        StringHolder errorStr = new StringHolder();
        if (!srvDefBuilder.is_valid(errorStr)) {
            throw new DaemonException("Error in the services definition: " + errorStr.value);
        }
        this.logger.log((Level)AcsLogLevel.DEBUG, "Services successfully validated by the ServicesDefinitionBuilder");
        return new AlarmServicesDefinitionHolder(svcsXML, Collections.unmodifiableList(services));
    }

    public void startACSServices(String xmlListOfServices) throws GettingDaemonException, DaemonException {
        if (xmlListOfServices == null || xmlListOfServices.isEmpty()) {
            throw new IllegalArgumentException("The XML list of services can't be null nor empty");
        }
        ServicesDaemon daemon = this.getServicesDaemon();
        ServiceDefinitionBuilder srvDefBuilder = null;
        try {
            srvDefBuilder = daemon.create_service_definition_builder((short)this.instance);
        }
        catch (Throwable t) {
            throw new DaemonException("Error getting the service definition builder", t);
        }
        this.logger.log((Level)AcsLogLevel.DEBUG, "ServiceDefinitionBuilder got from the ACS services daemon");
        try {
            srvDefBuilder.add_services_definition(xmlListOfServices);
        }
        catch (Throwable t) {
            throw new DaemonException("Error adding the list of services to the daemon", t);
        }
        StringHolder errorStr = new StringHolder();
        if (!srvDefBuilder.is_valid(errorStr)) {
            throw new DaemonException("Invalid XML list of services: " + errorStr.value);
        }
        this.internalStartServices(daemon, xmlListOfServices);
    }

    public AlarmServicesDefinitionHolder startACSServices() throws GettingDaemonException, HibernateException, DaemonException, TMCDBException {
        this.logger.log((Level)AcsLogLevel.DEBUG, "Starting ACS with services daemon");
        ServicesDaemon daemon = this.getServicesDaemon();
        this.logger.log((Level)AcsLogLevel.DEBUG, "Services daemon acquired");
        AlarmServicesDefinitionHolder holder = this.internalGetServicesDescription(daemon);
        this.internalStartServices(daemon, holder.xmlServicesDefinition);
        return holder;
    }

    private void internalStartServices(ServicesDaemon daemon, String svcsXML) throws DaemonException {
        if (daemon == null) {
            throw new IllegalArgumentException("The daemon can't be null");
        }
        if (svcsXML == null || svcsXML.isEmpty()) {
            throw new IllegalArgumentException("The XML list of services can't be null nor empty");
        }
        DaemonSequenceCallbackImpl callback = new DaemonSequenceCallbackImpl(this.logger, true);
        DaemonSequenceCallback daemonSequenceCallback = null;
        try {
            daemonSequenceCallback = DaemonSequenceCallbackHelper.narrow((Object)this.acsCorba.activateOffShoot((Servant)callback, this.acsCorba.getRootPOA()));
        }
        catch (Throwable t) {
            throw new DaemonException("Error starting the callback", t);
        }
        this.logger.log((Level)AcsLogLevel.DEBUG, "Asking the services daemon to start services");
        try {
            daemon.start_services(svcsXML, true, daemonSequenceCallback);
        }
        catch (Throwable t) {
            throw new DaemonException("Error starting the services", t);
        }
    }

    public void stopServices(String xmlListOfServices) throws GettingDaemonException, DaemonException {
        if (xmlListOfServices == null || xmlListOfServices.isEmpty()) {
            throw new IllegalArgumentException("The XML list of services can't be null nor empty");
        }
        this.logger.log((Level)AcsLogLevel.DEBUG, "Stopping ACS with the services daemon");
        ServicesDaemon daemon = this.getServicesDaemon();
        DaemonSequenceCallbackImpl callback = new DaemonSequenceCallbackImpl(this.logger, false);
        DaemonSequenceCallback daemonSequenceCallback = null;
        try {
            daemonSequenceCallback = DaemonSequenceCallbackHelper.narrow((Object)this.acsCorba.activateOffShoot((Servant)callback, this.acsCorba.getRootPOA()));
        }
        catch (Throwable t) {
            throw new DaemonException("Error instantiating the callback", t);
        }
        this.logger.log((Level)AcsLogLevel.DEBUG, "Asking the services daemon to stop services");
        try {
            daemon.stop_services(xmlListOfServices, daemonSequenceCallback);
        }
        catch (Throwable t) {
            throw new DaemonException("Error stopping services", t);
        }
    }

    public void addServiceListener(ServicesListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener can't be null");
        }
        this.listeners.add(listener);
    }

    public boolean removeServiceListener(ServicesListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener can't be null");
        }
        return this.listeners.remove(listener);
    }

    private List<TMCDBServicesHelper.AcsServiceToStart> getServicesList() throws HibernateException {
        TMCDBServicesHelper tmcdbHelper = new TMCDBServicesHelper(this.logger, this.session);
        return tmcdbHelper.getServicesList(this.configurationName);
    }

    private ServicesDaemon getServicesDaemon() throws GettingDaemonException {
        ServicesDaemon daemon;
        String daemonLoc = AcsLocations.convertToServicesDaemonLocation((String)this.daemonHost);
        this.logger.log((Level)AcsLogLevel.DEBUG, "Getting services daemon from " + this.daemonHost);
        try {
            Object object = this.acsCorba.getORB().string_to_object(daemonLoc);
            daemon = ServicesDaemonHelper.narrow((Object)object);
            if (daemon == null) {
                throw new GettingDaemonException("Received null trying to retrieve acs services daemon on " + this.daemonHost);
            }
            if (daemon._non_existent()) {
                throw new GettingDaemonException("Acs services daemon not existing on " + this.daemonHost);
            }
        }
        catch (Throwable t) {
            throw new GettingDaemonException("Error getting the services daemon " + t.getMessage(), t);
        }
        return daemon;
    }

    private class ServicesHelperThreadFactory
    implements ThreadFactory,
    Thread.UncaughtExceptionHandler {
        private final ThreadGroup threadGroup;

        public ServicesHelperThreadFactory(String name) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Invalig name: " + name);
            }
            this.threadGroup = new ThreadGroup(name);
        }

        @Override
        public Thread newThread(Runnable r) {
            if (r == null) {
                throw new IllegalArgumentException("Invalid NULL runnable!");
            }
            Thread t = new Thread(this.threadGroup, r);
            t.setDaemon(true);
            t.setUncaughtExceptionHandler(this);
            return t;
        }

        public Thread newThread(Runnable r, String name) {
            Thread t = this.newThread(r);
            t.setName(name);
            return t;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.out.println("Thread " + t.getName() + " terminated with uncaught exception: " + e.getMessage());
            e.printStackTrace();
            StartServicesHelper.this.logger.log((Level)AcsLogLevel.ERROR, "Thread " + t.getName() + " terminated with uncaught exception", e);
        }
    }

    public class AlarmServicesDefinitionHolder {
        public final String xmlServicesDefinition;
        public final List<TMCDBServicesHelper.AcsServiceToStart> services;

        public AlarmServicesDefinitionHolder(String xml, List<TMCDBServicesHelper.AcsServiceToStart> services) {
            this.xmlServicesDefinition = xml;
            this.services = services;
        }
    }

    public class DaemonException
    extends Exception {
        public DaemonException(String errorStr) {
            super(errorStr);
        }

        public DaemonException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public class TMCDBException
    extends Exception {
        public TMCDBException(String errorStr) {
            super(errorStr);
        }

        public TMCDBException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public class DaemonSequenceCallbackImpl
    extends DaemonSequenceCallbackPOA {
        private final AcsLogger logger;
        private final boolean startingServices;

        public DaemonSequenceCallbackImpl(AcsLogger logger, boolean starting) {
            if (logger == null) {
                throw new IllegalArgumentException("The logger can't be null");
            }
            this.logger = logger;
            this.startingServices = starting;
        }

        public void done(Completion comp) {
            this.logger.log((Level)AcsLogLevel.DEBUG, "Done: comp=" + comp.timeStamp);
            this.notifyListenersDone(comp.type, comp.code);
        }

        public void working(String service, String host, short instance_number, Completion comp) {
            this.logger.log((Level)AcsLogLevel.DEBUG, "Working: service=" + service + " host=" + host + " instance=" + instance_number + " comp=" + comp.timeStamp);
            this.notifyListenersStartStop(this.startingServices, service, host, StartServicesHelper.this.instance, comp.type, comp.code);
        }

        private void notifyListenersStartStop(final boolean starting, final String serviceName, final String hostName, final int instance, final int errorType, final int errorCode) {
            if (StartServicesHelper.this.listeners.isEmpty()) {
                return;
            }
            Thread listenersUpdaterThread = StartServicesHelper.this.threadFactory.newThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set<ServicesListener> set = StartServicesHelper.this.listeners;
                    synchronized (set) {
                        for (ServicesListener listener : StartServicesHelper.this.listeners) {
                            try {
                                if (starting) {
                                    listener.serviceStarted(serviceName, hostName, instance, errorType, errorCode);
                                    continue;
                                }
                                listener.serviceStopped(serviceName, hostName, instance, errorType, errorCode);
                            }
                            catch (Throwable t) {
                                System.err.println("Exception caught notifying working to listener " + t.getMessage());
                                t.printStackTrace();
                                DaemonSequenceCallbackImpl.this.logger.log((Level)AcsLogLevel.ERROR, "Exception caught notifying working to listener", t);
                            }
                        }
                    }
                }
            }, "notifyWorking " + serviceName + "@" + hostName);
            listenersUpdaterThread.setName("ListenersUpdaterStartStopThread");
            listenersUpdaterThread.setDaemon(true);
            listenersUpdaterThread.start();
        }

        private void notifyListenersDone(final int errorType, final int errorCode) {
            if (StartServicesHelper.this.listeners.isEmpty()) {
                return;
            }
            Thread listenersUpdaterThread = StartServicesHelper.this.threadFactory.newThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set<ServicesListener> set = StartServicesHelper.this.listeners;
                    synchronized (set) {
                        for (ServicesListener listener : StartServicesHelper.this.listeners) {
                            try {
                                listener.done(errorType, errorCode);
                            }
                            catch (Throwable t) {
                                System.err.println("Exception caught notifying done to listener " + t.getMessage());
                                t.printStackTrace();
                                DaemonSequenceCallbackImpl.this.logger.log((Level)AcsLogLevel.ERROR, "Exception caught notifying done to listener", t);
                            }
                        }
                    }
                }
            }, "notifyDone");
            listenersUpdaterThread.setName("ListenersUpdaterDoneThread");
            listenersUpdaterThread.setDaemon(true);
            listenersUpdaterThread.start();
        }
    }

    public class GettingDaemonException
    extends Exception {
        public GettingDaemonException(String errorStr) {
            super(errorStr);
        }

        public GettingDaemonException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface ServicesListener {
        public void done(int var1, int var2);

        public void serviceStarted(String var1, String var2, int var3, int var4, int var5);

        public void serviceStopped(String var1, String var2, int var3, int var4, int var5);
    }
}

