/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.serviceshelper;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.tmcdb.AcsServiceServiceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

class TMCDBServicesHelper {
    private final String namedParameterName = "configname";
    private final String sqlQuery = "select s.serviceinstancename, s.servicetype, nd.networkname from configuration conf inner join acsservice s   on conf.configurationid = s.configurationid   inner join computer comp   on comp.networkdeviceid=s.computerid   inner join networkdevice nd   on nd.networkdeviceid = comp.networkdeviceid where conf.configurationname = :configname";
    private final AcsLogger logger;
    private final Session session;

    public TMCDBServicesHelper(AcsLogger logger, Session session) {
        if (logger == null) {
            throw new IllegalArgumentException("The logger can't be null!");
        }
        if (session == null) {
            throw new IllegalArgumentException("The session can't be null!");
        }
        this.logger = logger;
        this.session = session;
    }

    public Collection getConfigurationNames() throws HibernateException {
        Query query = this.session.createQuery("from Configuration");
        List list = query.getResultList();
        return list;
    }

    public List<AcsServiceToStart> getServicesList(String configurationName) throws HibernateException {
        if (configurationName == null || configurationName.isEmpty()) {
            throw new IllegalArgumentException("Invalid null or empty name of configuration");
        }
        this.logger.log((Level)AcsLogLevel.DEBUG, "Getting the list of services from TMCDB and configuration " + configurationName);
        NativeQuery query = this.session.createNativeQuery("select s.serviceinstancename, s.servicetype, nd.networkname from configuration conf inner join acsservice s   on conf.configurationid = s.configurationid   inner join computer comp   on comp.networkdeviceid=s.computerid   inner join networkdevice nd   on nd.networkdeviceid = comp.networkdeviceid where conf.configurationname = :configname");
        query.setParameter("configname", (Object)configurationName);
        List svcs = query.getResultList();
        ArrayList<AcsServiceToStart> ret = new ArrayList<AcsServiceToStart>();
        if (svcs != null) {
            AcsLogLevel lvl = svcs.size() == 0 ? AcsLogLevel.WARNING : AcsLogLevel.DEBUG;
            this.logger.log((Level)lvl, "Got " + svcs.size() + " services from TMCDB");
            for (Object s : svcs) {
                ret.add(AcsServiceToStart.instanceFromDBRow((Object[])s));
            }
        } else {
            this.logger.log((Level)AcsLogLevel.WARNING, "Got a NULL list of services from TMCDB");
        }
        return ret;
    }

    public static class AcsServiceToStart {
        public final String serviceName;
        public final AcsServiceServiceType serviceType;
        public final String hostName;

        private AcsServiceToStart(String name, AcsServiceServiceType type, String host) {
            this.serviceName = name;
            this.serviceType = type;
            this.hostName = host;
        }

        public static AcsServiceToStart instanceFromDBRow(Object[] row) {
            if (row == null || row.length != 3) {
                throw new IllegalArgumentException("Invalid row: must be not null and have a length of 3");
            }
            return new AcsServiceToStart((String)row[0], AcsServiceServiceType.valueOf((String)((String)row[1])), (String)row[2]);
        }
    }
}

