/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.util;

public class StringRingBuffer {
    protected char[] data;
    protected int next = 0;
    protected boolean isFillingUp = true;

    public StringRingBuffer(int size) {
        this.data = new char[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(char obj) {
        int overwritten = -1;
        char[] cArray = this.data;
        synchronized (this.data) {
            overwritten = this.data[this.next];
            this.data[this.next] = obj;
            this.next = this.inc(this.next);
            if (this.isFillingUp && this.next == 0) {
                this.isFillingUp = false;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return overwritten;
        }
    }

    public int size() {
        return this.isFillingUp ? this.next : this.data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getAll() {
        char[] cArray = this.data;
        synchronized (this.data) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.copyToNewArray(this.size());
        }
    }

    public boolean equals(String other) {
        if (other.length() != this.size()) {
            return false;
        }
        int otherIdx = 0;
        if (this.isFillingUp) {
            int idx = 0;
            while (idx < this.next) {
                if (this.data[idx] != other.charAt(otherIdx)) {
                    return false;
                }
                ++idx;
                ++otherIdx;
            }
        } else {
            int idx = this.next;
            while (idx < this.data.length) {
                if (this.data[idx] != other.charAt(otherIdx)) {
                    return false;
                }
                ++idx;
                ++otherIdx;
            }
            idx = 0;
            while (idx < this.next) {
                if (this.data[idx] != other.charAt(otherIdx)) {
                    return false;
                }
                ++idx;
                ++otherIdx;
            }
        }
        return true;
    }

    public String toString() {
        return new String(this.getAll());
    }

    private char[] copyToNewArray(int size) {
        char[] ret = new char[size];
        if (this.isFillingUp) {
            System.arraycopy(this.data, 0, ret, 0, this.next);
        } else {
            System.arraycopy(this.data, this.next, ret, 0, this.data.length - this.next);
            System.arraycopy(this.data, 0, ret, this.data.length - this.next, this.next);
        }
        return ret;
    }

    private int inc(int i) {
        return ++i == this.data.length ? 0 : i;
    }
}

