/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.CatalogFactory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.MemoryCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.coords.CoordinateRadius;
import jsky.util.gui.DialogUtil;

public abstract class AbstractCatalogDirectory
implements CatalogDirectory,
Serializable {
    private static final long serialVersionUID = 1L;
    private String _name;
    private String _id;
    private URL _url;
    private List<Catalog> _catalogs = new ArrayList<Catalog>();
    private transient HTMLQueryResultHandler _htmlQueryResultHandler;
    private transient CatalogDirectory _parent;
    protected transient EventListenerList _listenerList = new EventListenerList();

    public AbstractCatalogDirectory(String name) {
        this._name = this._id = name;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractCatalogDirectory catDir = (AbstractCatalogDirectory)super.clone();
        catDir._catalogs = new ArrayList<Catalog>(this._catalogs);
        return catDir;
    }

    @Override
    public CatalogDirectory getParent() {
        return this._parent;
    }

    @Override
    public void setParent(CatalogDirectory dir) {
        if (dir != this) {
            this._parent = dir;
        }
    }

    public HTMLQueryResultHandler getHTMLQueryResultHandler() {
        return this._htmlQueryResultHandler;
    }

    public void setHTMLQueryResultHandler(HTMLQueryResultHandler handler) {
        this._htmlQueryResultHandler = handler;
    }

    public String toString() {
        return this._name;
    }

    @Override
    public void addCatalog(int index, Catalog cat) {
        int i = this._catalogs.indexOf(cat);
        if (i != -1) {
            return;
        }
        String name = cat.getName();
        Catalog oldCat = this.getCatalog(name);
        int size = this._catalogs.size();
        if (oldCat != null) {
            int ans = DialogUtil.confirm((String)(name + " already exists. Do you want to replace it?"));
            if (ans != 0) {
                return;
            }
            this.removeCatalog(oldCat);
            --size;
        }
        if (index < 0 || index >= size) {
            this._catalogs.add(cat);
        } else {
            this._catalogs.add(index, cat);
        }
        cat.setParent(this);
        CatalogFactory.registerCatalog(cat, this.isLocal());
        this._fireTreeNodesInserted(this._getTreeModelEvent(cat));
    }

    @Override
    public void addCatalog(Catalog cat) {
        this.addCatalog(this._catalogs.size(), cat);
    }

    @Override
    public void removeCatalog(Catalog cat) {
        TreeModelEvent tme = this._getTreeModelEvent(cat);
        this._catalogs.remove(cat);
        this._fireTreeNodesRemoved(tme);
        cat.setParent(null);
        CatalogFactory.unregisterCatalog(cat);
    }

    @Override
    public void replaceCatalog(Catalog oldCat, Catalog newCat) {
        int i = this._catalogs.indexOf(oldCat);
        if (i != -1) {
            this._catalogs.set(i, newCat);
            newCat.setParent(this);
            this._fireTreeNodesChanged(this._getTreeModelEvent(newCat));
        }
    }

    @Override
    public void moveCatalog(Catalog cat, boolean up) {
        int i = this._catalogs.indexOf(cat);
        if (i == -1 || up && i == 0 || !up && i == this._catalogs.size() - 1) {
            return;
        }
        this.removeCatalog(cat);
        this.addCatalog(i + (up ? -1 : 1), cat);
    }

    @Override
    public void moveCatalogToEnd(Catalog cat, boolean up) {
        int i = this._catalogs.indexOf(cat);
        if (i == -1 || up && i == 0 || !up && i == this._catalogs.size() - 1) {
            return;
        }
        this.removeCatalog(cat);
        if (up) {
            this.addCatalog(0, cat);
        } else {
            this.addCatalog(cat);
        }
    }

    @Override
    public Catalog getCatalog(String catalogName) {
        int n = this.getNumCatalogs();
        for (int i = 0; i < n; ++i) {
            Catalog cat = this.getCatalog(i);
            if (!catalogName.equals(cat.getName()) && !catalogName.equals(cat.getId())) continue;
            return cat;
        }
        return null;
    }

    @Override
    public Catalog findCatalog(String catalogName) {
        int n = this.getNumCatalogs();
        for (int i = 0; i < n; ++i) {
            Catalog cat = this.getCatalog(i);
            if (catalogName.equals(cat.getName()) || catalogName.equals(cat.getId())) {
                return cat;
            }
            if (!(cat instanceof CatalogDirectory) || (cat = ((CatalogDirectory)cat).findCatalog(catalogName)) == null) continue;
            return cat;
        }
        return null;
    }

    @Override
    public int getNumCatalogs() {
        return this._catalogs.size();
    }

    @Override
    public Catalog getCatalog(int i) {
        return this._catalogs.get(i);
    }

    @Override
    public int indexOf(Catalog cat) {
        return this._catalogs.indexOf(cat);
    }

    @Override
    public void setCatalogs(List<Catalog> catalogs) {
        this._catalogs = catalogs;
        int n = this._catalogs.size();
        for (int i = 0; i < n; ++i) {
            Catalog cat = this._catalogs.get(i);
            cat.setParent(this);
            CatalogFactory.registerCatalog(cat, this.isLocal());
        }
        this._fireTreeStructureChanged(this._getTreeModelEvent(this));
    }

    @Override
    public List<Catalog> getCatalogs() {
        return this._catalogs;
    }

    @Override
    public TableQueryResult getCatalogList() {
        FieldDesc[] columns = new FieldDescAdapter[]{new FieldDescAdapter("Title")};
        int numCatalogs = this.getNumCatalogs();
        Vector rows = new Vector(numCatalogs, 1);
        for (int i = 0; i < numCatalogs; ++i) {
            Vector<Catalog> cols = new Vector<Catalog>(1, 1);
            cols.add(this.getCatalog(i));
            rows.add(cols);
        }
        MemoryCatalog result = new MemoryCatalog(columns, rows);
        result.setName(this._name);
        result.setTitle(this._name);
        result.setDescription(this._name);
        return result;
    }

    @Override
    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        this._url = url;
    }

    @Override
    public boolean configNeedsUrl() {
        return false;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getTitle() {
        return this.getName();
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    @Override
    public String getDescription() {
        if (this._url != null) {
            return this._name + " [" + this._url.toString() + "]";
        }
        return this._name;
    }

    @Override
    public URL getDocURL() {
        return null;
    }

    @Override
    public int getNumParams() {
        return 0;
    }

    @Override
    public FieldDesc getParamDesc(int i) {
        return null;
    }

    @Override
    public FieldDesc getParamDesc(String name) {
        return null;
    }

    @Override
    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius region) {
    }

    @Override
    public boolean isLocal() {
        return this._url != null && this._url.getProtocol().equals("file");
    }

    @Override
    public boolean isImageServer() {
        return false;
    }

    @Override
    public String getType() {
        return "directory";
    }

    @Override
    public QueryResult query(QueryArgs queryArgs) throws IOException {
        return this;
    }

    @Override
    public List<Catalog> getNameServers() {
        return CatalogFactory.getCatalogsByType("namesvr");
    }

    public AbstractCatalogDirectory getRootCatalogDirectory() {
        return (AbstractCatalogDirectory)this.getRoot();
    }

    @Override
    public Object getRoot() {
        AbstractCatalogDirectory rootDir = null;
        for (CatalogDirectory catDir = this; catDir != null; catDir = catDir.getParent()) {
            rootDir = catDir;
        }
        return rootDir;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof CatalogDirectory) {
            CatalogDirectory catDir = (CatalogDirectory)parent;
            if (index >= 0 && index < catDir.getNumCatalogs()) {
                return catDir.getCatalog(index);
            }
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof CatalogDirectory) {
            CatalogDirectory catDir = (CatalogDirectory)parent;
            return catDir.getNumCatalogs();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof Catalog && !((Catalog)node).getType().equals("directory");
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this._fireTreeNodesChanged(this._getTreeModelEvent((Catalog)newValue));
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof CatalogDirectory && child instanceof Catalog) {
            CatalogDirectory catDir = (CatalogDirectory)parent;
            Catalog cat = (Catalog)child;
            return catDir.indexOf(cat);
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (this._listenerList == null) {
            this._listenerList = new EventListenerList();
        }
        this._listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        if (this._listenerList != null) {
            this._listenerList.remove(TreeModelListener.class, l);
        }
    }

    protected TreeModelEvent _getTreeModelEvent(Catalog cat) {
        int[] childIndices;
        Object[] path;
        AbstractCatalogDirectory source = this;
        CatalogDirectory catDir = cat.getParent();
        if (catDir == null) {
            path = new Catalog[]{cat};
            childIndices = new int[]{0};
        } else {
            path = this.getPath(catDir);
            childIndices = new int[]{catDir.indexOf(cat)};
        }
        Object[] children = new Object[]{cat};
        return new TreeModelEvent((Object)source, path, childIndices, children);
    }

    @Override
    public Catalog[] getPath(Catalog cat) {
        CatalogDirectory dir;
        if (cat == null) {
            return null;
        }
        ArrayList<Catalog> l = new ArrayList<Catalog>();
        if (cat instanceof CatalogDirectory) {
            dir = (CatalogDirectory)cat;
        } else {
            dir = cat.getParent();
            l.add(cat);
        }
        while (dir != null) {
            l.add(dir);
            dir = dir.getParent();
        }
        int n = l.size();
        Catalog[] ar = new Catalog[n];
        for (int i = 0; i < n; ++i) {
            ar[n - i - 1] = (Catalog)l.get(i);
        }
        return ar;
    }

    @Override
    public Catalog[] getPath() {
        return this.getPath(this);
    }

    protected void _fireTreeNodesChanged(TreeModelEvent e) {
        AbstractCatalogDirectory root = this.getRootCatalogDirectory();
        if (root != null && this != root) {
            root._fireTreeNodesChanged(e);
            return;
        }
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void _fireTreeNodesInserted(TreeModelEvent e) {
        AbstractCatalogDirectory root = this.getRootCatalogDirectory();
        if (root != null && this != root) {
            root._fireTreeNodesInserted(e);
            return;
        }
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void _fireTreeNodesRemoved(TreeModelEvent e) {
        if (this._listenerList == null) {
            return;
        }
        AbstractCatalogDirectory root = this.getRootCatalogDirectory();
        if (root != null && this != root) {
            root._fireTreeNodesRemoved(e);
            return;
        }
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void _fireTreeStructureChanged(TreeModelEvent e) {
        if (this._listenerList == null) {
            return;
        }
        AbstractCatalogDirectory root = this.getRootCatalogDirectory();
        if (root != null && this != root) {
            root._fireTreeStructureChanged(e);
            return;
        }
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }
}

