/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.astrogrid.protocols.ivo;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import uk.ac.starlink.astrogrid.AcrConnection;

public class IvoURLConnection
extends URLConnection {
    private final AcrConnection aconn_;
    private InputStream inStrm_;
    private OutputStream outStrm_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IvoURLConnection(AcrConnection aconn, URL url) {
        super(url);
        this.aconn_ = aconn;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.doInput && this.doOutput) {
            throw new IOException("Can't open ivo: URL for both input and output");
        }
        if (this.doInput) {
            this.inStrm_ = this.createInputStream();
            this.connected = true;
        } else if (this.doOutput) {
            this.outStrm_ = this.createOutputStream();
            this.connected = true;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.inStrm_;
    }

    public OutputStream getOutputStream() throws IOException {
        this.connect();
        return this.outStrm_;
    }

    private InputStream createInputStream() throws IOException {
        String inLoc = this.aconn_.execute("astrogrid.myspace.getReadContentURL", new String[]{this.url.toString()}).toString();
        return new FilterInputStream(new URL(inLoc).openStream()){

            public boolean markSupported() {
                return false;
            }
        };
    }

    private OutputStream createOutputStream() throws IOException {
        return this.aconn_.getOutputStream(this.url.toString());
    }

    static {
        $assertionsDisabled = !IvoURLConnection.class.desiredAssertionStatus();
    }
}

