/*
 * Decompiled with CFR 0.152.
 */
package diva.graph;

import diva.canvas.CanvasComponent;
import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.FigureLayer;
import diva.canvas.Site;
import diva.canvas.connector.AutonomousSite;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorAdapter;
import diva.canvas.connector.ConnectorEvent;
import diva.canvas.connector.ConnectorManipulator;
import diva.canvas.connector.ConnectorTarget;
import diva.canvas.connector.PerimeterTarget;
import diva.canvas.connector.Terminal;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.BasicSelectionRenderer;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionModel;
import diva.graph.EdgeController;
import diva.graph.EdgeInteractor;
import diva.graph.EdgeRenderer;
import diva.graph.GraphController;
import diva.graph.GraphException;
import diva.graph.GraphModel;
import diva.graph.GraphViewEvent;
import diva.graph.MutableGraphModel;
import java.awt.geom.Rectangle2D;

public class BasicEdgeController
implements EdgeController {
    private ConnectorTarget _connectorTarget;
    private Interactor _interactor;
    private EdgeRenderer _renderer;
    private GraphController _controller;

    public BasicEdgeController(GraphController controller) {
        this._controller = controller;
        SelectionModel sm = controller.getSelectionModel();
        this._interactor = new EdgeInteractor(sm);
        ConnectorManipulator manipulator = new ConnectorManipulator();
        manipulator.setSnapHalo(4.0);
        manipulator.addConnectorListener(new EdgeDropper());
        ((EdgeInteractor)this._interactor).setPrototypeDecorator(manipulator);
        MouseFilter handleFilter = new MouseFilter(1, 0, 0);
        manipulator.setHandleFilter(handleFilter);
        PerimeterTarget ct = new PerimeterTarget(){

            public boolean acceptHead(Connector c, Figure f) {
                Object node = f.getUserObject();
                Object edge = c.getUserObject();
                MutableGraphModel model = (MutableGraphModel)BasicEdgeController.this._controller.getGraphModel();
                if (model.isNode(node) && model.isEdge(edge) && model.acceptHead(edge, node)) {
                    return super.acceptHead(c, f);
                }
                return false;
            }

            public boolean acceptTail(Connector c, Figure f) {
                Object node = f.getUserObject();
                Object edge = c.getUserObject();
                MutableGraphModel model = (MutableGraphModel)BasicEdgeController.this._controller.getGraphModel();
                if (model.isNode(node) && model.isEdge(edge) && model.acceptTail(edge, node)) {
                    return super.acceptTail(c, f);
                }
                return false;
            }

            public Site getHeadSite(Figure f, double x, double y) {
                if (f instanceof Terminal) {
                    Site site = ((Terminal)f).getConnectSite();
                    return site;
                }
                return super.getHeadSite(f, x, y);
            }
        };
        this.setConnectorTarget(ct);
    }

    public void addEdge(Object edge, Object node, int end, double x, double y) {
        MutableGraphModel model = (MutableGraphModel)this._controller.getGraphModel();
        Figure nf = this._controller.getFigure(node);
        FigureLayer layer = this._controller.getGraphPane().getForegroundLayer();
        Site headSite = new AutonomousSite(layer, x, y);
        Site tailSite = new AutonomousSite(layer, x, y);
        Connector c = this.render(edge, layer, tailSite, headSite);
        try {
            if (end == 22) {
                tailSite = this.getConnectorTarget().getTailSite(c, nf, x, y);
                if (tailSite == null) {
                    throw new RuntimeException("Invalid connector target: no valid site found for tail of new connector.");
                }
                model.setEdgeTail(this._controller, edge, node);
                c.setTailSite(tailSite);
            } else {
                headSite = this.getConnectorTarget().getHeadSite(c, nf, x, y);
                if (headSite == null) {
                    throw new RuntimeException("Invalid connector target: no valid site found for head of new connector.");
                }
                model.setEdgeHead(this._controller, edge, node);
                c.setHeadSite(headSite);
            }
        }
        catch (GraphException ex) {
            this.removeEdge(edge);
            throw ex;
        }
    }

    public void addEdge(Object edge, Object tail, Object head) {
        MutableGraphModel model = (MutableGraphModel)this._controller.getGraphModel();
        model.connectEdge(this._controller, edge, tail, head);
        this.drawEdge(edge);
    }

    public void clearEdge(Object edge) {
        Figure f = this._controller.getFigure(edge);
        if (f != null) {
            CanvasComponent container = f.getParent();
            f.setUserObject(null);
            this._controller.setFigure(edge, null);
            if (container instanceof FigureLayer) {
                ((FigureLayer)container).remove(f);
            } else if (container instanceof CompositeFigure) {
                ((CompositeFigure)container).remove(f);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Figure drawEdge(Object edge) {
        Site headSite;
        Rectangle2D bounds;
        Site tailSite;
        GraphModel model = this._controller.getGraphModel();
        FigureLayer layer = this._controller.getGraphPane().getForegroundLayer();
        Object tail = model.getTail(edge);
        Object head = model.getHead(edge);
        Connector connector = (Connector)this._controller.getFigure(edge);
        Figure tailFigure = this._controller.getFigure(tail);
        Figure headFigure = this._controller.getFigure(head);
        if (tailFigure == null) {
            if (connector == null) return null;
            tailSite = connector.getTailSite();
        } else {
            bounds = tailFigure.getBounds();
            tailSite = this.getConnectorTarget().getTailSite(tailFigure, bounds.getCenterX(), bounds.getCenterY());
        }
        if (headFigure == null) {
            if (connector == null) return null;
            headSite = connector.getHeadSite();
        } else {
            bounds = headFigure.getBounds();
            headSite = this.getConnectorTarget().getHeadSite(headFigure, bounds.getCenterX(), bounds.getCenterY());
        }
        if (connector != null) {
            this.clearEdge(edge);
        }
        Connector c = this.render(edge, layer, tailSite, headSite);
        this._controller.dispatch(new GraphViewEvent(this, 21, edge));
        return c;
    }

    public ConnectorTarget getConnectorTarget() {
        return this._connectorTarget;
    }

    public GraphController getController() {
        return this._controller;
    }

    public Interactor getEdgeInteractor() {
        return this._interactor;
    }

    public EdgeRenderer getEdgeRenderer() {
        return this._renderer;
    }

    public void removeEdge(Object edge) {
        this.clearEdge(edge);
        MutableGraphModel model = (MutableGraphModel)this._controller.getGraphModel();
        model.setEdgeHead(this._controller, edge, null);
        model.setEdgeTail(this._controller, edge, null);
        this._controller.getGraphPane().repaint();
    }

    public void setConnectorTarget(ConnectorTarget t) {
        this._connectorTarget = t;
        BasicSelectionRenderer selectionRenderer = (BasicSelectionRenderer)((EdgeInteractor)this._interactor).getSelectionRenderer();
        ConnectorManipulator manipulator = (ConnectorManipulator)selectionRenderer.getDecorator();
        manipulator.setConnectorTarget(t);
    }

    public void setEdgeInteractor(Interactor interactor) {
        this._interactor = interactor;
    }

    public void setEdgeRenderer(EdgeRenderer er) {
        this._renderer = er;
    }

    public Connector render(Object edge, FigureLayer layer, Site tailSite, Site headSite) {
        Connector ef = this.getEdgeRenderer().render(edge, tailSite, headSite);
        ef.setInteractor(this.getEdgeInteractor());
        ef.setUserObject(edge);
        this._controller.setFigure(edge, ef);
        layer.add(ef);
        ef.route();
        return ef;
    }

    protected class EdgeDropper
    extends ConnectorAdapter {
        protected EdgeDropper() {
        }

        public void connectorDropped(ConnectorEvent evt) {
            Connector c = evt.getConnector();
            Figure f = evt.getTarget();
            Object edge = c.getUserObject();
            Object node = f == null ? null : f.getUserObject();
            MutableGraphModel model = (MutableGraphModel)BasicEdgeController.this._controller.getGraphModel();
            try {
                switch (evt.getEnd()) {
                    case 21: {
                        model.setEdgeHead(BasicEdgeController.this._controller, edge, node);
                        break;
                    }
                    case 22: {
                        model.setEdgeTail(BasicEdgeController.this._controller, edge, node);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Cannot handle both ends of an edge being dragged.");
                    }
                }
            }
            catch (GraphException ex) {
                SelectionModel selectionModel = BasicEdgeController.this._controller.getSelectionModel();
                if (selectionModel.containsSelection(c)) {
                    selectionModel.removeSelection(c);
                }
                BasicEdgeController.this.removeEdge(edge);
                throw ex;
            }
        }
    }
}

