/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component;

import alma.ACS.ACSComponentOperations;
import alma.ACS.ComponentStates;
import alma.acs.component.ComponentLifecycle;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;
import alma.acs.logging.AcsLogger;
import alma.maciErrType.wrappers.AcsJComponentCleanUpEx;

public class ComponentImplBase
implements ComponentLifecycle,
ACSComponentOperations {
    protected String m_instanceName;
    protected ContainerServices m_containerServices;
    protected AcsLogger m_logger;

    @Override
    public void initialize(ContainerServices containerServices) throws ComponentLifecycleException {
        this.m_containerServices = containerServices;
        this.checkProperInit();
        this.m_instanceName = containerServices.getName();
        this.m_logger = this.m_containerServices.getLogger();
    }

    @Override
    public void execute() throws ComponentLifecycleException {
        this.checkProperInit();
    }

    @Override
    public void cleanUp() throws AcsJComponentCleanUpEx {
    }

    @Override
    public void aboutToAbort() {
        this.m_logger.fine("calling cleanUp() from the abort thread...");
        try {
            this.cleanUp();
        }
        catch (AcsJComponentCleanUpEx ex) {
            ex.printStackTrace();
        }
    }

    public ComponentStates componentState() {
        this.checkProperInit();
        ComponentStates state = this.m_containerServices.getComponentStateManager().getCurrentState();
        return state;
    }

    public String name() {
        this.checkProperInit();
        return this.m_instanceName;
    }

    private void checkProperInit() {
        if (this.m_containerServices == null) {
            String msg = "Component base class 'ComponentImplBase' is not properly initialized: 'initialize(containerServices)' was not called at all, or with a null arg.";
            throw new IllegalStateException(msg);
        }
    }
}

