/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.JavaContainerError.wrappers.AcsJContainerEx;
import alma.acs.component.dynwrapper.DynWrapperException;
import alma.acs.container.corba.CorbaNullFinder;
import alma.acs.exceptions.CorbaExceptionConverter;
import alma.acs.logging.AcsLogLevel;
import alma.acs.monitoring.DynamicInterceptor;
import alma.acs.util.StopWatch;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class ContainerSealant {
    public static final String CHECK_NULLS_CORBA_OUT_PROPERTYNAME = "alma.acs.container.check_nulls_corba_out";

    public static <T> T createContainerSealant(Class<T> corbaInterface, Object component, String name, boolean isOffShoot, Logger logger, ClassLoader componentContextCL, String[] methodNamesExcludedFromInvocationLogging) throws AcsJContainerEx {
        if (!corbaInterface.isInstance(component)) {
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo("sealant factory: component " + component.getClass().getName() + " must implement the sealant interface " + corbaInterface.getClass().getName());
            throw ex;
        }
        ComponentInterceptionHandlerFactory interceptionHandlerFactory = new ComponentInterceptionHandlerFactory(name, isOffShoot, logger, methodNamesExcludedFromInvocationLogging);
        return (T)DynamicInterceptor.createDynamicInterceptor(corbaInterface, (Object)component, (Logger)logger, (ClassLoader)componentContextCL, (DynamicInterceptor.InterceptionHandlerFactory)interceptionHandlerFactory);
    }

    private static class ComponentInterceptionHandlerFactory
    implements DynamicInterceptor.InterceptionHandlerFactory {
        private final String name;
        private final boolean isOffShoot;
        private final Logger logger;
        private final Set<String> methodNamesExcludedFromInvocationLogging;

        ComponentInterceptionHandlerFactory(String name, boolean isOffShoot, Logger logger, String[] excludedMethods) {
            this.name = name;
            this.isOffShoot = isOffShoot;
            this.logger = logger;
            this.methodNamesExcludedFromInvocationLogging = new HashSet<String>(2);
            this.setExcludedMethods(excludedMethods);
        }

        private void setExcludedMethods(String[] excludedMethods) {
            this.methodNamesExcludedFromInvocationLogging.add("componentState");
            if (excludedMethods != null) {
                try {
                    if (this.isOffShoot) {
                        String actualInterfaceName = this.name.substring(this.name.lastIndexOf(47) + 1);
                        for (int i = 0; i < excludedMethods.length; ++i) {
                            String interfaceName;
                            int methodNamePosition;
                            String qualExclMethodName = excludedMethods[i];
                            if (!qualExclMethodName.startsWith("OFFSHOOT::") || (methodNamePosition = qualExclMethodName.indexOf(35) + 1) <= 0 || !(interfaceName = qualExclMethodName.substring("OFFSHOOT::".length(), methodNamePosition - 1)).equals(actualInterfaceName)) continue;
                            String methodName = qualExclMethodName.substring(methodNamePosition);
                            this.methodNamesExcludedFromInvocationLogging.add(methodName);
                        }
                    } else {
                        this.methodNamesExcludedFromInvocationLogging.addAll(Arrays.asList(excludedMethods));
                    }
                    if (this.logger.isLoggable(Level.FINE) && !this.methodNamesExcludedFromInvocationLogging.isEmpty()) {
                        StringBuffer buff = new StringBuffer(100);
                        buff.append("Container will not log invocations of the following methods of ");
                        buff.append(this.isOffShoot ? "offshoot '" : "component '");
                        buff.append(this.name).append("' :");
                        Iterator<String> iter = this.methodNamesExcludedFromInvocationLogging.iterator();
                        while (iter.hasNext()) {
                            String methodName = iter.next();
                            buff.append(methodName);
                            if (!iter.hasNext()) continue;
                            buff.append(", ");
                        }
                        this.logger.fine(buff.toString());
                    }
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "failed to exclude certain methods of '" + this.name + "' from future automatic invocation logging.", ex);
                }
            }
        }

        public DynamicInterceptor.InterceptionHandler createInterceptionHandler() {
            return new ComponentInterceptionHandler(this.name, this.isOffShoot, this.logger, this.methodNamesExcludedFromInvocationLogging);
        }
    }

    private static class ComponentInterceptionHandler
    implements DynamicInterceptor.InterceptionHandler {
        private final String name;
        private final Logger logger;
        private final Set<String> methodNamesExcludedFromInvocationLogging;
        private StopWatch methodInvWatch;
        private final Level logLevel;
        private boolean isLoggable = false;
        private Method method;

        ComponentInterceptionHandler(String name, boolean isOffShoot, Logger logger, Set<String> methodNamesExcludedFromInvocationLogging) {
            this.name = name;
            this.logger = logger;
            this.methodNamesExcludedFromInvocationLogging = methodNamesExcludedFromInvocationLogging;
            this.logLevel = isOffShoot ? AcsLogLevel.TRACE : AcsLogLevel.DELOUSE;
        }

        public boolean callReceived(Method method, Object[] args) {
            this.method = method;
            boolean bl = this.isLoggable = !this.isExcludedFromInvocationLogging(method.getName()) && this.logger.isLoggable(this.logLevel);
            if (this.isLoggable) {
                String qualMethodName = this.name + "#" + method.getName();
                this.methodInvWatch = new StopWatch(this.logger);
                this.logger.log(this.logLevel, "intercepted a call to '" + qualMethodName + "'.");
            }
            return true;
        }

        public Object callFinished(Object retVal, Object[] args, Throwable realThr) throws Throwable {
            String qualMethodName = this.name + "#" + this.method.getName();
            if (this.isLoggable) {
                this.logger.log(this.logLevel, "returning from " + qualMethodName + " after " + this.methodInvWatch.getLapTimeMillis() + " ms.");
            }
            if (realThr != null) {
                if (realThr instanceof UserException) {
                    boolean declared = false;
                    Class<?>[] declaredExceptions = this.method.getExceptionTypes();
                    for (int i = 0; i < declaredExceptions.length; ++i) {
                        if (declaredExceptions[i] != realThr.getClass()) continue;
                        declared = true;
                        break;
                    }
                    Object msg = declared ? "checked exception " : "unchecked user exception (should have been declared in IDL!) ";
                    msg = (String)msg + "was thrown in functional method '" + qualMethodName + "':";
                    Level exLogLevel = declared ? this.logLevel : Level.WARNING;
                    Throwable thrExpanded = CorbaExceptionConverter.convertHiddenErrorTrace((Throwable)realThr);
                    this.logger.log(exLogLevel, (String)msg, thrExpanded);
                    throw realThr;
                }
                if (realThr instanceof DynWrapperException) {
                    String msg = "the dynamic xml entity translator failed with the functional method '" + qualMethodName + "': ";
                    this.logger.log(Level.SEVERE, msg, realThr);
                    throw new DATA_CONVERSION(msg + realThr.toString());
                }
                this.logger.log(Level.WARNING, "Unexpected exception was thrown in functional method '" + qualMethodName + "': ", realThr);
                if (realThr instanceof SystemException) {
                    throw realThr;
                }
                throw new UNKNOWN(realThr.toString());
            }
            if (Boolean.getBoolean(ContainerSealant.CHECK_NULLS_CORBA_OUT_PROPERTYNAME)) {
                try {
                    CorbaNullFinder finder;
                    Class<?> clzzRet = this.method.getReturnType();
                    if (!Void.TYPE.equals(clzzRet) && !CorbaNullFinder.isIDLInterfaceClass(clzzRet) && (finder = new CorbaNullFinder(retVal)).hasErrors()) {
                        List<String> errors = finder.getErrors();
                        StringBuilder sb = new StringBuilder();
                        for (String errorline : errors) {
                            sb.append(errorline).append("\n");
                        }
                        this.logger.warning("Illegal null value returned by method " + this.method.getName() + ":\n" + sb.toString());
                    }
                    Class<?>[] argsClasses = this.method.getParameterTypes();
                    StringBuilder sb = new StringBuilder();
                    for (int argIndex = 0; argIndex < argsClasses.length; ++argIndex) {
                        CorbaNullFinder finder2;
                        Class<?> clzzOutParam = argsClasses[argIndex];
                        if (!clzzOutParam.getSimpleName().endsWith("Holder") || CorbaNullFinder.isIDLInterfaceClass(clzzOutParam) || !(finder2 = new CorbaNullFinder(args[argIndex])).hasErrors()) continue;
                        List<String> errors = finder2.getErrors();
                        sb.append("  Parameter " + clzzOutParam.getSimpleName() + ": \n");
                        for (String errorline : errors) {
                            sb.append("    ").append(errorline).append("\n");
                        }
                    }
                    String paramErrors = sb.toString();
                    if (!paramErrors.isEmpty()) {
                        this.logger.warning("Illegal null value in out parameter(s) of method " + this.method.getName() + ":\n" + paramErrors);
                    }
                }
                catch (Exception ex) {
                    this.logger.log(Level.FINE, "Failed to check returned data for illegal nulls.", ex);
                }
            }
            return retVal;
        }

        private boolean isExcludedFromInvocationLogging(String methodName) {
            return this.methodNamesExcludedFromInvocationLogging.contains(methodName);
        }
    }
}

