/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.valuetypes.UserFrequency;

public final class ScienceSpectralWindowFactory {
    private static final String SINGLE_CONTINUUM_TRANSITION_NAME = "Single Continuum";

    public static ScienceSpectralWindow createScienceSpectralWindow(double d, String string, int n) {
        CorrConfigMode corrConfigMode = CorrConfigMode.getCorrConfigMode(n);
        double d2 = corrConfigMode.getNominalBandwidth().getContentInMHz();
        double d3 = corrConfigMode.getResolution().getContentInMHz();
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindowFactory.createScienceSpectralWindow(d, string, d2, d3);
        scienceSpectralWindow.setCorrConfigMode(corrConfigMode);
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createScienceSpectralWindow(double d, String string, double d2, double d3) {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.getCenterFrequency().setContentInGHz(d);
        scienceSpectralWindow.setTransitionName(string);
        UserFrequency userFrequency = UserFrequency.createUserFrequencyMHZ(d2);
        userFrequency.setObservingFrequency(scienceSpectralWindow.getCenterFrequency());
        scienceSpectralWindow.setBandWidth(userFrequency);
        userFrequency = UserFrequency.createUserFrequencyMHZ(d3);
        userFrequency.setObservingFrequency(scienceSpectralWindow.getCenterFrequency());
        scienceSpectralWindow.setSpectralResolution(userFrequency);
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createScienceSpectralWindow(double d, String string, double d2, int n) {
        return ScienceSpectralWindowFactory.createScienceSpectralWindow(d, string, d2, n, "FULL");
    }

    public static ScienceSpectralWindow createScienceSpectralWindow(double d, String string, double d2, int n, String string2) {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.getCenterFrequency().setContentInGHz(d);
        scienceSpectralWindow.setTransitionName(string);
        scienceSpectralWindow.getBandWidth().setContentInMHz(d2);
        scienceSpectralWindow.getBandWidth().getObservingFrequency().setContentInGHz(d);
        scienceSpectralWindow.getSpectralResolution().setContentInMHz(d2 / (double)n);
        scienceSpectralWindow.getSpectralResolution().getObservingFrequency().setContentInGHz(d);
        scienceSpectralWindow.setGroupResourceUse(string2);
        scienceSpectralWindow.resetCorrConfigMode();
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createSingleTDMContinuum() {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.setTransitionName(SINGLE_CONTINUUM_TRANSITION_NAME);
        scienceSpectralWindow.setIsSkyFrequency(true);
        scienceSpectralWindow.setBandWidth(UserFrequency.createUserFrequency(ScienceSpectralWindow.getSingleContinuumBandwidth()));
        scienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(1);
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createSingleFDMContinuum() {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.setTransitionName(SINGLE_CONTINUUM_TRANSITION_NAME);
        scienceSpectralWindow.setIsSkyFrequency(true);
        scienceSpectralWindow.setBandWidth(UserFrequency.createUserFrequency(ScienceSpectralWindow.getSingleContinuumBandwidth()));
        scienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(2);
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createSingleVLBIContinuumWindow() {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.setTransitionName(SINGLE_CONTINUUM_TRANSITION_NAME);
        scienceSpectralWindow.setIsSkyFrequency(true);
        scienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(8);
        scienceSpectralWindow.setCorrConfigMode(52);
        scienceSpectralWindow.setBandWidth(UserFrequency.createUserFrequency(ScienceSpectralWindow.getSingleVLBIContinuumBandwidth()));
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createSingleVLBISpectralLineWindow() {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.setIsSkyFrequency(true);
        scienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(8);
        scienceSpectralWindow.setCorrConfigMode(52);
        scienceSpectralWindow.setBandWidth(UserFrequency.createUserFrequency(ScienceSpectralWindow.getSingleVLBIContinuumBandwidth()));
        return scienceSpectralWindow;
    }

    public static ScienceSpectralWindow createSingleB2BSpectralLineWindow() {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.setIsSkyFrequency(false);
        scienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(8);
        scienceSpectralWindow.setCorrConfigMode(142);
        scienceSpectralWindow.setBandWidth(UserFrequency.createUserFrequency(CorrConfigMode.getCorrConfigMode(142).getNominalBandwidth()));
        return scienceSpectralWindow;
    }

    private ScienceSpectralWindowFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

