/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.AbstractBaseBandConfigT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityPartException;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.enumerations.NetSideBand;
import alma.obsprep.bo.enumerations.ReceiverType;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.schedblock.ACASpectralWindowPair;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BLSpectralWindowPair;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.DataRateChangeEvent;
import alma.obsprep.bo.schedblock.DataRateNode;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowPair;
import alma.obsprep.bo.schedblock.TooManySpectralWindowsException;
import alma.obsprep.bo.schedblock.data.AbstractBaseBandConfigData;
import alma.obsprep.ot.valdef.corrconfig.CorrelatorConfigDataRate;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;

public abstract class AbstractBaseBandConfig
extends AbstractBaseBandConfigData
implements BaseBand,
DataRateNode {
    private final SpectralWindowPairManager spectralWindowPairManager = new SpectralWindowPairManager(this);

    public AbstractBaseBandConfig(AbstractBaseBandConfigT abstractBaseBandConfigT) {
        super(abstractBaseBandConfigT);
    }

    public void initAsNew() {
        super.initAsNew();
        this.setDataProducts(DATAPRODUCTS_CROSS_AND_AUTO);
    }

    public String detailString() {
        StringBuilder stringBuilder = new StringBuilder(this.toString());
        for (AbstractSpectralWindow abstractSpectralWindow : this.getSingleSpectralWindow()) {
            stringBuilder.append("\n\t" + abstractSpectralWindow.detailString());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + "@" + this.hashCode());
        stringBuilder.append(",name=" + this.getBaseBandName());
        stringBuilder.append("[");
        stringBuilder.append("center=" + String.valueOf((Object)this.getCenterFrequency()) + ",");
        stringBuilder.append("prod=" + this.getDataProducts() + ",");
        stringBuilder.append("switchT=" + this.getSwitchingType() + ",");
        stringBuilder.append(this.getSpectralWindowCount() + "SWs");
        return stringBuilder.toString();
    }

    public AbstractCorrelatorConfiguration getCorrelatorConfiguration() {
        try {
            return (AbstractCorrelatorConfiguration)this.getParent();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public SpectralSpec getSpectralSpec() {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
        return abstractCorrelatorConfiguration == null ? null : (SpectralSpec)abstractCorrelatorConfiguration.getParent();
    }

    public static boolean isPairMode(ReceiverType receiverType, String string, boolean bl) {
        if (receiverType != ReceiverType.DSB || DATAPRODUCTS_AUTO_ONLY.equals(string)) {
            return false;
        }
        return bl;
    }

    public boolean isPairMode() {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration == null) {
            return false;
        }
        SpectralSpec spectralSpec = this.getSpectralSpec();
        if (spectralSpec == null) {
            return false;
        }
        ReceiverType receiverType = ReceiverType.getReceiverType(spectralSpec.getReceiverType());
        return AbstractBaseBandConfig.isPairMode(receiverType, this.getDataProducts(), abstractCorrelatorConfiguration.getEnable90DegreeWalshFunction());
    }

    public void addSpectralWindow(SpectralWindowI spectralWindowI) {
        this.addSpectralWindow(this.getSpectralWindowCount(), spectralWindowI);
    }

    public SpectralWindowI addNewSpectralWindow() {
        return this.addNewSpectralWindow(this.getSpectralWindowCount());
    }

    public void addSpectralWindow(int n, SpectralWindowI spectralWindowI) {
        if (this.isPairMode()) {
            this.spectralWindowPairManager.addSpectralWindowPair(n, (SpectralWindowPair)spectralWindowI);
        } else {
            this.addSingleSpectralWindow(n, (AbstractSpectralWindow)spectralWindowI);
        }
    }

    public SpectralWindowI copyAndAddSpectralWindow(int n, int n2) {
        if (n2 == -1) {
            n2 = this.getSpectralWindowCount();
        }
        SpectralWindowI spectralWindowI = null;
        if (n >= 0 && n < this.getSpectralWindowCount()) {
            SpectralWindowI spectralWindowI2 = this.getBaseBandConfig().getSpectralWindow(n);
            try {
                spectralWindowI = (SpectralWindowI)((BusinessObject)spectralWindowI2).deepCopy();
            }
            catch (ClassCastException classCastException) {
                spectralWindowI = ((SpectralWindowPair)spectralWindowI2).createCopy();
            }
            this.addSpectralWindow(n2, spectralWindowI);
        } else {
            spectralWindowI = this.addNewSpectralWindow(n2);
        }
        return spectralWindowI;
    }

    public SpectralWindowI createNewSpectralWindow() {
        if (this.isPairMode()) {
            return this.spectralWindowPairManager.createNewPair();
        }
        return this.createNewSingleSpectralWindow();
    }

    public SpectralWindowI addNewSpectralWindow(int n) {
        if (this.isPairMode()) {
            return this.spectralWindowPairManager.addNewSpectralWindowPair(n);
        }
        AbstractSpectralWindow abstractSpectralWindow = this.createNewSingleSpectralWindow();
        this.addSingleSpectralWindow(n, abstractSpectralWindow);
        abstractSpectralWindow.setDefaultSideBand();
        return abstractSpectralWindow;
    }

    public boolean removeSpectralWindow(SpectralWindowI spectralWindowI) {
        if (this.isPairMode()) {
            return this.spectralWindowPairManager.removeSpectralWindowPair((SpectralWindowPair)spectralWindowI);
        }
        return this.removeSingleSpectralWindow((AbstractSpectralWindow)spectralWindowI);
    }

    @Override
    public SpectralWindowI getSpectralWindow(int n) {
        if (this.isPairMode()) {
            return this.spectralWindowPairManager.getSpectralWindowPair(n);
        }
        return this.getSingleSpectralWindow(n);
    }

    @Override
    public SpectralWindowI[] getSpectralWindow() {
        if (this.isPairMode()) {
            return this.spectralWindowPairManager.getSpectralWindowPair();
        }
        return this.getSingleSpectralWindow();
    }

    @Override
    public int getSpectralWindowCount() {
        if (this.isPairMode()) {
            return this.spectralWindowPairManager.getSpectralWindowPairCount();
        }
        return this.getSingleSpectralWindowCount();
    }

    @Override
    public void refreshPairList() {
        if (this.isPairMode()) {
            this.spectralWindowPairManager.refreshPairList();
        }
    }

    protected void forgetPairs() {
        if (this.isPairMode()) {
            this.spectralWindowPairManager.forgetPairs();
        }
    }

    private void updatePairMode() throws TooManySpectralWindowsException {
        boolean bl;
        if (this.getSingleSpectralWindowCount() == 0) {
            return;
        }
        boolean bl2 = this.getSingleSpectralWindow(0).isPartOfPair();
        if (bl2 != (bl = this.isPairMode())) {
            if (bl) {
                int n = this.getSpectralWindowCount() * 2;
                if (AbstractBaseBandConfig.maxSpectralWindowCount() <= n) {
                    throw new TooManySpectralWindowsException("Too many SpectralWindows to use both sidebands : " + n);
                }
                this.spectralWindowPairManager.convertSingleToPair();
            } else {
                this.spectralWindowPairManager.convertPairToSingle();
            }
        }
        for (SpectralWindowI spectralWindowI : this.getSpectralWindow()) {
            spectralWindowI.updateSideband();
        }
    }

    public void walsh90updated() throws TooManySpectralWindowsException {
        this.updatePairMode();
    }

    public void walsh180updated(boolean bl) {
    }

    public void dataProductsUpdated() throws TooManySpectralWindowsException {
        this.updatePairMode();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration != null) {
            abstractCorrelatorConfiguration.dataRateChanged();
        }
    }

    public void setDataProducts(String string) throws IllegalArgumentException {
        String string2 = this.getDataProducts();
        super.setDataProducts(string);
        try {
            this.dataProductsUpdated();
        }
        catch (TooManySpectralWindowsException tooManySpectralWindowsException) {
            this.setDataProducts(string2);
        }
    }

    public abstract void clearSpectralWindow();

    public abstract void addSingleSpectralWindow(int var1, AbstractSpectralWindow var2);

    public abstract AbstractSpectralWindow createNewSingleSpectralWindow();

    public abstract boolean removeSingleSpectralWindow(AbstractSpectralWindow var1);

    public abstract CorrelatorType getCorrelatorType();

    public boolean inspectPairWindows() {
        for (int i = 0; i < this.getSingleSpectralWindowCount(); i += 2) {
            AbstractSpectralWindow abstractSpectralWindow;
            AbstractSpectralWindow abstractSpectralWindow2;
            try {
                abstractSpectralWindow2 = this.getSingleSpectralWindow(i);
                abstractSpectralWindow = this.getSingleSpectralWindow(i + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            if (AbstractSpectralWindow.SIDEBAND_LSB.equals(abstractSpectralWindow2.getSideBand()) && AbstractSpectralWindow.SIDEBAND_USB.equals(abstractSpectralWindow.getSideBand()) && abstractSpectralWindow2.getAssociatedSpectralWindowNumberInPair() == i + 2 && abstractSpectralWindow.getAssociatedSpectralWindowNumberInPair() == i + 1) continue;
            return false;
        }
        return true;
    }

    protected void adjustSpectralWindowName() {
        for (int i = 0; i < this.getSingleSpectralWindowCount(); ++i) {
            int n = i + 1;
            this.getSingleSpectralWindow(i).setName("SW-" + n);
        }
    }

    public boolean isACA() {
        return this.getCorrelatorType() == CorrelatorType.ACA;
    }

    public Frequency getSpectralWindowCenterFrequency(int n) {
        AbstractSpectralWindow abstractSpectralWindow = this.getSpectralWindow(n).getSingleSpectralWindow();
        Frequency frequency = this.min();
        frequency = (Frequency)frequency.plus((AbstractDoubleWithUnit)abstractSpectralWindow.getCenterFrequency());
        return frequency;
    }

    public Frequency getSpectralWindowMinFrequency(int n) {
        AbstractSpectralWindow abstractSpectralWindow = this.getSpectralWindow(n).getSingleSpectralWindow();
        Frequency frequency = this.min();
        frequency = (Frequency)frequency.plus((AbstractDoubleWithUnit)abstractSpectralWindow.getCenterFrequency());
        frequency = (Frequency)frequency.minus((AbstractDoubleWithUnit)abstractSpectralWindow.getHalfBandwidth());
        return frequency;
    }

    public Frequency getSpectralWindowMaxFrequency(int n) {
        AbstractSpectralWindow abstractSpectralWindow = this.getSpectralWindow(n).getSingleSpectralWindow();
        Frequency frequency = this.min();
        frequency = (Frequency)frequency.plus((AbstractDoubleWithUnit)abstractSpectralWindow.getCenterFrequency());
        frequency = (Frequency)frequency.plus((AbstractDoubleWithUnit)abstractSpectralWindow.getHalfBandwidth());
        return frequency;
    }

    public void setSpectralWindowCenterFrequency(int n, Frequency frequency) {
        AbstractSpectralWindow abstractSpectralWindow = this.getSpectralWindow(n).getSingleSpectralWindow();
        frequency = (Frequency)frequency.minus((AbstractDoubleWithUnit)this.min());
        abstractSpectralWindow.getCenterFrequency().setContent(frequency.getContent());
        abstractSpectralWindow.getCenterFrequency().setUnit(frequency.getUnit());
    }

    public Range getGHZRangeForSpectralWindow(int n) {
        Range range = null;
        AbstractSpectralWindow abstractSpectralWindow = this.getSpectralWindow(n).getSingleSpectralWindow();
        double d = abstractSpectralWindow.getBandwidth().getContentInGHz() / 2.0;
        double d2 = this.min().getContentInGHz();
        double d3 = this.max().getContentInGHz();
        range = new Range(d2 - d, d3 + d);
        return range;
    }

    public void updateSpectralWindowSideband() {
        for (SpectralWindowI spectralWindowI : this.getSpectralWindow()) {
            spectralWindowI.updateSideband();
        }
    }

    void updateDataProducts() {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration == null) {
            return;
        }
        String string = abstractCorrelatorConfiguration.getCAM();
        if (AbstractCorrelatorConfiguration.CAM_FAST.equals(string)) {
            this.setDataProducts(DATAPRODUCTS_AUTO_ONLY);
        } else if (AbstractCorrelatorConfiguration.CAM_NORMAL.equals(string)) {
            this.setDataProducts(DATAPRODUCTS_CROSS_AND_AUTO);
        }
    }

    public static int maxChannelAverageRegionCount() {
        return 32;
    }

    public static int maxSpectralWindowCount() {
        return 32;
    }

    public static String[] getKnownDataProductsList() {
        return TextUtils.removeFromArray(knownDataProductsList, DATAPRODUCTS_CROSS_ONLY);
    }

    public void adjustAssociatedSpectralWindowNumber() {
        this.spectralWindowPairManager.adjustAssociatedSpectralWindowNumber();
    }

    public int findSpectralWindow(SpectralWindowI spectralWindowI) {
        for (int i = 0; i < this.getSpectralWindowCount(); ++i) {
            if (this.getSpectralWindow(i) != spectralWindowI) continue;
            return i;
        }
        return -1;
    }

    public int findSingleSpectralWindow(AbstractSpectralWindow abstractSpectralWindow) {
        for (int i = 0; i < this.getSingleSpectralWindowCount(); ++i) {
            if (this.getSingleSpectralWindow(i) != abstractSpectralWindow) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DataRate getInstantaneousDataRate() {
        CorrelatorConfigDataRate correlatorConfigDataRate = this.getCorrelatorConfiguration().getDataRateCalculator();
        return correlatorConfigDataRate.getBasebandTotalDataRate(this);
    }

    @Override
    public DataRateNode getParentDataRateNode() {
        return (DataRateNode)this.getParent();
    }

    protected void dataRateChanged() {
        this.dataRateChanged(new DataRateChangeEvent(this));
    }

    @Override
    public void dataRateChanged(DataRateChangeEvent dataRateChangeEvent) {
        DataRateNode dataRateNode = this.getParentDataRateNode();
        if (dataRateNode != null) {
            dataRateNode.dataRateChanged(dataRateChangeEvent);
        }
    }

    @Override
    public void format(Formatter formatter, String object) {
        formatter.format("%s%s@%h%n", object, this.getClass().getSimpleName(), this.hashCode());
        object = (String)object + "\t";
        formatter.format("%sIndex                      = %d%n", object, this.getBaseBandIndex() + 1);
        formatter.format("%sData Products              = %s%n", object, this.getDataProducts());
        formatter.format("%sPair Mode (calculated)     = %b%n", object, this.isPairMode());
        formatter.format("%sSpectral Window Pair Count = %d%n", object, this.spectralWindowPairManager.getSpectralWindowPairCount());
        formatter.format("%sSpectral Window Count      = %d%n", object, this.getSpectralWindowCount());
        formatter.format("%sSpectral Window Pairs%n", object);
        for (SpectralWindowPair spectralWindowI : this.spectralWindowPairManager.getSpectralWindowPair()) {
            formatter.format("%sLSB:\t%s%n", object, spectralWindowI.getLSB());
            formatter.format("%sUSB:\t%s%n", object, spectralWindowI.getUSB());
        }
        formatter.format("%sSpectral Windows%n", object);
        for (SpectralWindowI spectralWindowI : this.getSpectralWindow()) {
            formatter.format("%s\t%s%n", object, spectralWindowI);
        }
        formatter.format("%sSingle Spectral Windows%n", object);
        for (SpectralWindowI spectralWindowI : this.getSingleSpectralWindow()) {
            formatter.format("%s\t%s%n", object, spectralWindowI);
        }
    }

    @Override
    public int getBaseBandIndex() {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration != null) {
            for (int i = 0; i < abstractCorrelatorConfiguration.getBaseBandConfigCount(); ++i) {
                if (this != abstractCorrelatorConfiguration.getBaseBandConfig(i)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public BaseBandSpecification getBaseBandSpecification() {
        try {
            return super.getBaseBandSpecification();
        }
        catch (UnknownEntityPartException unknownEntityPartException) {
            return null;
        }
    }

    public String getSwitchingType() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        return spectralSpec == null ? null : spectralSpec.getSwitchingType();
    }

    public void setSwitchingType(String string) {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        if (spectralSpec != null) {
            this.getSpectralSpec().setSwitchingType(string);
        }
    }

    public Velocity getSourceVelocity() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        return spectralSpec == null ? Velocity.createVelocity() : spectralSpec.getSourceVelocity();
    }

    @Override
    public String getBaseBandName() {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        return baseBandSpecification == null ? null : baseBandSpecification.getBaseBandName();
    }

    public void setBaseBandName(String string) {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        if (baseBandSpecification != null) {
            this.getBaseBandSpecification().setBaseBandName(string);
        }
    }

    public void setCenterFrequency(Frequency frequency) {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        if (baseBandSpecification != null) {
            this.getBaseBandSpecification().setCenterFrequency(frequency);
        }
    }

    public Frequency getLO2Frequency() {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        return baseBandSpecification == null ? null : baseBandSpecification.getLO2Frequency();
    }

    Frequency getSkyFrequencyLSB(Frequency frequency) {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        return baseBandSpecification == null ? null : baseBandSpecification.getSkyFrequencyLSB(frequency);
    }

    Frequency getSkyFrequencyUSB(Frequency frequency) {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        return baseBandSpecification == null ? null : baseBandSpecification.getSkyFrequencyUSB(frequency);
    }

    public boolean isRejectionMode() {
        if (DATAPRODUCTS_AUTO_ONLY.equals(this.getDataProducts())) {
            return false;
        }
        this.getCorrelatorConfiguration();
        return !this.isPairMode();
    }

    public Frequency[] getLOFrequencies() {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        return baseBandSpecification == null ? null : baseBandSpecification.getLOFrequencies();
    }

    public SideBandUse getSideBandUse() {
        String string = this.getSpectralSpec().getReceiverType();
        if (string.equals(SpectralSpec.RECEIVERTYPE_DSB) && !this.isRejectionMode()) {
            return SideBandUse.SIDEBANDUSE_BOTH;
        }
        if (string.equals(SpectralSpec.RECEIVERTYPE_SSB)) {
            String string2 = this.getSpectralSpec().getFrequencySetup().getReceiverBand();
            ReceiverBand receiverBand = ReceiverBand.getReceiverBand(string2);
            if (receiverBand.isLowerSidebandPresent()) {
                return SideBandUse.SIDEBANDUSE_LSB;
            }
            return SideBandUse.SIDEBANDUSE_USB;
        }
        Frequency frequency = this.getSpectralSpec().getLO1Frequency();
        Frequency frequency2 = this.getCenterFrequencySky();
        if (frequency2.isLessThan((AbstractDoubleWithUnit)frequency)) {
            return SideBandUse.SIDEBANDUSE_LSB;
        }
        return SideBandUse.SIDEBANDUSE_USB;
    }

    Frequency getSkyFrequency(Frequency frequency, NetSideBand netSideBand) {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        return baseBandSpecification == null ? null : baseBandSpecification.getSkyFrequency(frequency, netSideBand);
    }

    public void setLO2Frequency(Frequency frequency) {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        if (baseBandSpecification != null) {
            this.getBaseBandSpecification().setLO2Frequency(frequency);
        }
    }

    @Override
    public Frequency min() {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        return baseBandSpecification == null ? null : baseBandSpecification.getMinFrequency();
    }

    @Override
    public Frequency max() {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        return baseBandSpecification == null ? null : baseBandSpecification.getMaxFrequency();
    }

    @Override
    public Frequency getCenterFrequency() {
        return this.mid();
    }

    @Override
    public Frequency getCenterFrequencySky() {
        Frequency frequency = this.getCenterFrequency();
        if (FrequencySetup.DOPPLERREFERENCE_TOPO == this.getSpectralSpec().getFrequencySetup().getDopplerReference()) {
            return frequency;
        }
        return this.getSourceVelocity().dopplerShift(frequency);
    }

    @Override
    public Frequency mid() {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        return baseBandSpecification == null ? null : baseBandSpecification.getCenterFrequency();
    }

    @Override
    public Frequency getBandwidth() {
        return this.range();
    }

    @Override
    public Frequency range() {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        return baseBandSpecification == null ? null : baseBandSpecification.getBandwidth();
    }

    @Override
    public AbstractBaseBandConfig getBaseBandConfig() {
        return this;
    }

    public boolean isValidBasebandName() {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = this.getCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration == null) {
            return true;
        }
        for (AbstractBaseBandConfig abstractBaseBandConfig : abstractCorrelatorConfiguration.getBaseBandConfig()) {
            if (abstractBaseBandConfig == this || !abstractBaseBandConfig.getBaseBandName().equals(this.getBaseBandName())) continue;
            return false;
        }
        return true;
    }

    private class SpectralWindowPairManager {
        private final AbstractBaseBandConfig bbc;
        private final List<SpectralWindowPair> pairList = new ArrayList<SpectralWindowPair>();

        protected SpectralWindowPairManager(AbstractBaseBandConfig abstractBaseBandConfig2) {
            this.bbc = abstractBaseBandConfig2;
        }

        protected SpectralWindowPair createEmptyPair() {
            SpectralWindowPair spectralWindowPair = this.bbc.getCorrelatorType() == CorrelatorType.ACA ? new ACASpectralWindowPair(this.bbc) : new BLSpectralWindowPair(this.bbc);
            return spectralWindowPair;
        }

        protected SpectralWindowPair createNewPair() {
            return this.createNewPair(this.bbc.createNewSingleSpectralWindow());
        }

        protected SpectralWindowPair createNewPair(AbstractSpectralWindow abstractSpectralWindow) {
            SpectralWindowPair spectralWindowPair = this.createEmptyPair();
            AbstractSpectralWindow abstractSpectralWindow2 = abstractSpectralWindow.deepCopy();
            abstractSpectralWindow.setSideBand(AbstractSpectralWindow.SIDEBAND_LSB);
            abstractSpectralWindow2.setSideBand(AbstractSpectralWindow.SIDEBAND_USB);
            spectralWindowPair.setSpectralWindows(abstractSpectralWindow, abstractSpectralWindow2);
            spectralWindowPair.setCenterFrequency(abstractSpectralWindow.getCenterFrequency());
            return spectralWindowPair;
        }

        protected SpectralWindowPair addSpectralWindowPair(int n, SpectralWindowPair spectralWindowPair) {
            this.bbc.addSingleSpectralWindow(n * 2, spectralWindowPair.getLSB());
            this.bbc.addSingleSpectralWindow(n * 2 + 1, spectralWindowPair.getUSB());
            spectralWindowPair.getLSB().setAssociatedSpectralWindowNumberInPair(n * 2 + 1 + 1);
            spectralWindowPair.getUSB().setAssociatedSpectralWindowNumberInPair(n * 2 + 1);
            this.pairList.add(n, spectralWindowPair);
            this.adjustAssociatedSpectralWindowNumber();
            this.bbc.adjustSpectralWindowName();
            return spectralWindowPair;
        }

        protected SpectralWindowPair addNewSpectralWindowPair(int n) {
            SpectralWindowPair spectralWindowPair = this.createNewPair();
            return this.addSpectralWindowPair(n, spectralWindowPair);
        }

        protected boolean removeSpectralWindowPair(SpectralWindowPair spectralWindowPair) {
            if (spectralWindowPair == null) {
                return false;
            }
            this.bbc.removeSingleSpectralWindow(spectralWindowPair.getLSB());
            this.bbc.removeSingleSpectralWindow(spectralWindowPair.getUSB());
            this.pairList.remove(spectralWindowPair);
            this.adjustAssociatedSpectralWindowNumber();
            return true;
        }

        public void adjustAssociatedSpectralWindowNumber() {
            for (int i = 0; i < this.pairList.size(); ++i) {
                SpectralWindowPair spectralWindowPair = this.pairList.get(i);
                spectralWindowPair.getLSB().setAssociatedSpectralWindowNumberInPair(i * 2 + 1 + 1);
                spectralWindowPair.getUSB().setAssociatedSpectralWindowNumberInPair(i * 2 + 1);
            }
        }

        protected SpectralWindowPair getSpectralWindowPair(int n) {
            return this.pairList.get(n);
        }

        protected SpectralWindowPair[] getSpectralWindowPair() {
            return this.pairList.toArray(new SpectralWindowPair[this.pairList.size()]);
        }

        protected int getSpectralWindowPairCount() {
            return this.pairList.size();
        }

        protected void forgetPairs() {
            this.pairList.clear();
        }

        protected void refreshPairList() {
            this.forgetPairs();
            if (!this.bbc.inspectPairWindows()) {
                return;
            }
            for (int i = 0; i < this.bbc.getSingleSpectralWindowCount(); i += 2) {
                SpectralWindowPair spectralWindowPair = this.createEmptyPair();
                spectralWindowPair.setSpectralWindows(this.bbc.getSingleSpectralWindow(i), this.bbc.getSingleSpectralWindow(i + 1));
                this.pairList.add(spectralWindowPair);
            }
        }

        protected void convertPairToSingle() {
            AbstractSpectralWindow[] abstractSpectralWindowArray = this.bbc.getSingleSpectralWindow();
            this.bbc.clearSpectralWindow();
            this.forgetPairs();
            for (int i = 0; i < abstractSpectralWindowArray.length; i += 2) {
                AbstractSpectralWindow abstractSpectralWindow = abstractSpectralWindowArray[i];
                abstractSpectralWindow.setUseThisSpectralWindow(true);
                abstractSpectralWindow.setAssociatedSpectralWindowNumberInPair(0);
                this.bbc.addSingleSpectralWindow(i / 2, abstractSpectralWindow);
                abstractSpectralWindow.setDefaultSideBand();
            }
        }

        protected void convertSingleToPair() {
            AbstractSpectralWindow[] abstractSpectralWindowArray = this.bbc.getSingleSpectralWindow();
            this.bbc.clearSpectralWindow();
            this.forgetPairs();
            for (AbstractSpectralWindow abstractSpectralWindow : abstractSpectralWindowArray) {
                SpectralWindowPair spectralWindowPair = this.createNewPair(abstractSpectralWindow);
                this.addSpectralWindowPair(this.bbc.getSpectralWindowCount(), spectralWindowPair);
            }
        }
    }
}

