/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.SourcePropertyT;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.data.SourcePropertyData;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Magnitude;

public class SourceProperty
extends SourcePropertyData {
    public SourceProperty(SourcePropertyT sourcePropertyT) {
        super(sourcePropertyT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.getSourceDiameter().setContent(0.0);
        this.getSourceDiameter().setUnit(Angle.UNIT_ARCSEC);
        this.getSourceFrequency().setContentInGHz(0.0);
        this.getSourceFluxI().setContent(0.0);
        this.getSourceFluxQ().setContent(0.0);
        this.getSourceFluxU().setContent(0.0);
        this.getSourceFluxV().setContent(0.0);
    }

    public static SourceProperty createVisibleMagnitude(double d) {
        SourceProperty sourceProperty = SourceProperty.createSourceProperty();
        sourceProperty.setSourceFrequency(Flux.visibleCentreFrequency());
        sourceProperty.setSourceFluxI(Flux.createFluxFromVisibleMagnitude(d));
        return sourceProperty;
    }

    public Magnitude getVisibleMagnitude() {
        Magnitude magnitude = Magnitude.createMagnitude();
        magnitude.setValue(this.getSourceFluxI().getVisibleMagnitude());
        return magnitude;
    }

    public void setVisibleMagnitude(double d) {
        this.getSourceFluxI().setVisibleMagnitude(d);
        this.setSourceFrequency(Flux.visibleCentreFrequency());
    }

    public void setVisibleMagnitude(Magnitude magnitude) {
        this.setVisibleMagnitude(magnitude.getValue());
    }

    protected void initAttribsAndPartsFrom(IBusinessObject iBusinessObject, Copier copier) {
        SourcePropertyData sourcePropertyData = (SourcePropertyData)iBusinessObject;
        this.setDateOfMeasurement(sourcePropertyData.getDateOfMeasurement());
        this.setSourceFrequency(sourcePropertyData.getSourceFrequency().deepCopy());
        this.setSourceFluxI(sourcePropertyData.getSourceFluxI().deepCopy());
        this.setSourceDiameter(sourcePropertyData.getSourceDiameter().deepCopy());
        this.setSourceFluxQ(sourcePropertyData.getSourceFluxQ().deepCopy());
        this.setSourceFluxU(sourcePropertyData.getSourceFluxU().deepCopy());
        this.setSourceFluxV(sourcePropertyData.getSourceFluxV().deepCopy());
    }
}

