/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.investigator.tasks;

import alma.obsprep.ot.editors.investigator.InvestigatorSearchDialog;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.services.userlookup.User;
import alma.obsprep.services.userlookup.UserLookup;
import alma.obsprep.services.userlookup.UserLookupException;
import alma.obsprep.util.GUIUtilities;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class UserLookupTask
extends SwingWorker<Void, Void> {
    protected final InvestigatorSearchDialog dialog;
    protected final InvestigatorSearchDialog.TYPE searchType;
    protected final String[] searchStrings;

    public UserLookupTask(InvestigatorSearchDialog investigatorSearchDialog, InvestigatorSearchDialog.TYPE tYPE, String[] stringArray) {
        this.dialog = investigatorSearchDialog;
        this.searchType = tYPE;
        this.searchStrings = stringArray;
    }

    @Override
    public Void doInBackground() {
        try {
            UserLookup userLookup = ObservingToolController.getMyInstance().getUserLookup();
            List<User> list = null;
            if (this.searchType == InvestigatorSearchDialog.TYPE.EMAIL) {
                list = userLookup.matchEmail(this.searchStrings);
            }
            if (this.searchType == InvestigatorSearchDialog.TYPE.NAME) {
                list = userLookup.matchName(this.searchStrings);
            }
            if (this.searchType == InvestigatorSearchDialog.TYPE.UID) {
                list = userLookup.matchUid(this.searchStrings);
            }
            this.displayUserSelector(list);
        }
        catch (UserLookupException userLookupException) {
            this.cancel(false);
            GUIUtilities.error(null, "Could not contact the ALMA user lookup service.\nPlease check your network connection.", userLookupException);
        }
        return null;
    }

    protected void displayUserSelector(final List<User> list) {
        if (list == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserLookupTask.this.dialog.setUsers(list);
                if (list.isEmpty()) {
                    JOptionPane.showMessageDialog(UserLookupTask.this.dialog, "No matching users found.", "Search Results", 1);
                }
            }
        });
    }

    @Override
    public void done() {
        this.dialog.getProgressMonitor().close();
        this.dialog.setEnabled(true);
    }
}

