/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.jointproposals;

import alma.obsprep.bo.obsproposal.JointProposal;
import alma.obsprep.bo.obsproposal.JointProposalPartner;
import alma.obsprep.ot.models.obsproject.JointProposalModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Time;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import lombok.NonNull;

public class JointProposalTableModel
extends AbstractTableModel {
    JointProposalModel jointProposalModel;
    private JointProposalPartner[] partners;
    private boolean isMainObservatoryEditable = true;

    public JointProposalTableModel(@NonNull JointProposalModel jointProposalModel) {
        if (jointProposalModel == null) {
            throw new NullPointerException("jointProposalModel is marked non-null but is null");
        }
        this.setJointProposalModel(jointProposalModel);
        this.resetTableDocument();
    }

    @Override
    public int getColumnCount() {
        return ColumnDescriptor.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return ColumnDescriptor.getColumnDescriptor(n).getColumnName();
    }

    @Override
    public int getRowCount() {
        return this.partners == null ? 0 : this.partners.length;
    }

    public JointProposalPartner getPartnerObservatoryAt(int n) {
        return this.partners[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        JointProposalPartner jointProposalPartner = this.getPartnerObservatoryAt(n);
        switch (ColumnDescriptor.getColumnDescriptor(n2)) {
            case OBSERVATORY_COLUMN: {
                return jointProposalPartner.getObservatory().equals("") ? "Not set" : jointProposalPartner.getObservatory();
            }
            case MAIN_OBSERVATORY_COLUMN: {
                return jointProposalPartner.getIsMainObservatory();
            }
            case PROJECT_CODE_COLUMN: {
                return jointProposalPartner.getProjectCode().equals("") ? "Not set" : jointProposalPartner.getProjectCode();
            }
            case REQUESTED_TIME_COLUMN: {
                return jointProposalPartner.getRequestedTime();
            }
        }
        throw new IllegalArgumentException("Unrecognised column requested " + n2);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return ColumnDescriptor.getColumnDescriptor(n).getColumnClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (ColumnDescriptor.getColumnDescriptor(n2).equals((Object)ColumnDescriptor.MAIN_OBSERVATORY_COLUMN)) {
            return this.isMainObservatoryEditable;
        }
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        JointProposalPartner jointProposalPartner = this.getPartnerObservatoryAt(n);
        switch (ColumnDescriptor.getColumnDescriptor(n2)) {
            case MAIN_OBSERVATORY_COLUMN: {
                boolean bl = (Boolean)object;
                if (bl) {
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        JointProposalPartner jointProposalPartner2 = this.getPartnerObservatoryAt(i);
                        jointProposalPartner2.setIsMainObservatory(false);
                    }
                }
                jointProposalPartner.setIsMainObservatory((Boolean)object);
                if (bl) {
                    this.fireTableDataChanged();
                    break;
                }
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case OBSERVATORY_COLUMN: {
                String string = (String)object;
                for (int i = 0; i < this.getRowCount(); ++i) {
                    JointProposalPartner jointProposalPartner3 = this.getPartnerObservatoryAt(i);
                    if (!jointProposalPartner3.getObservatory().equals(string)) continue;
                    GUIUtilities.info(null, "This observatory is already included as a partner");
                    return;
                }
                jointProposalPartner.setObservatory(string);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case PROJECT_CODE_COLUMN: {
                jointProposalPartner.setProjectCode((String)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case REQUESTED_TIME_COLUMN: {
                jointProposalPartner.setRequestedTime((Time)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised column requested " + n2);
            }
        }
    }

    public Object[] getLongValues() {
        return new Object[]{"JWST", "2022.22.2222.S", Time.createTimeMin(60.0), Boolean.FALSE};
    }

    public JointProposal getDocument() {
        return this.jointProposalModel.getJointProposal();
    }

    public void resetTableDocument() {
        JointProposal jointProposal = this.jointProposalModel.getJointProposal();
        if (jointProposal == null) {
            return;
        }
        this.partners = jointProposal.getJointProposalPartner();
        this.fireTableDataChanged();
    }

    public void removeRow(int n) {
        if (n < 0) {
            GUIUtilities.info(null, "Select a partner observatory in the table to remove");
            return;
        }
        ArrayList<JointProposalPartner> arrayList = new ArrayList<JointProposalPartner>();
        int n2 = 0;
        for (JointProposalPartner jointProposalPartner2 : this.partners) {
            if (n2++ == n) continue;
            arrayList.add(jointProposalPartner2);
        }
        JointProposal jointProposal = this.jointProposalModel.getJointProposal();
        jointProposal.clearJointProposalPartner();
        arrayList.stream().forEach(jointProposalPartner -> jointProposal.addJointProposalPartner((JointProposalPartner)((Object)jointProposalPartner)));
        this.resetTableDocument();
    }

    public void setMainObservatoryEditable(boolean bl) {
        this.isMainObservatoryEditable = bl;
        if (!this.isMainObservatoryEditable) {
            this.jointProposalModel.resetMainObservatorySelected();
        }
        this.fireTableDataChanged();
    }

    public void setJointProposalModel(JointProposalModel jointProposalModel) {
        this.jointProposalModel = jointProposalModel;
    }

    public JointProposalModel getJointProposalModel() {
        return this.jointProposalModel;
    }

    public static enum ColumnDescriptor {
        OBSERVATORY_COLUMN("Observatory", String.class, 0),
        PROJECT_CODE_COLUMN("Project Code", String.class, 1),
        REQUESTED_TIME_COLUMN("Requested Time", Time.class, 2),
        MAIN_OBSERVATORY_COLUMN("Main Observatory", Boolean.class, 3);

        public final String columnName;
        public final Class<?> columnClass;
        public final int columnIndex;

        protected static int getColumnCount() {
            return ColumnDescriptor.values().length;
        }

        protected static ColumnDescriptor getColumnDescriptor(int n) {
            return ColumnDescriptor.values()[n];
        }

        private ColumnDescriptor(String string2, Class<?> clazz, int n2) {
            this.columnName = string2;
            this.columnClass = clazz;
            this.columnIndex = n2;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }
    }
}

