/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.schedblock.CrossPattern;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.CrossPatternEditor;
import alma.obsprep.ot.models.valuetypes.CoordsModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;

public class CrossPatternModel
extends Model {
    private CoordsModel patternCenterCoordsModel = new CoordsModel(null);
    private ValueUnitPairModel longitudeLengthModel = null;
    private ValueUnitPairModel latitudeLengthModel = new ValueUnitPairModel(null);
    private ValueUnitPairModel scanVelocityModel = null;
    private ValueUnitPairModel orientationModel = null;

    public CrossPatternModel(Object object) {
        super(object);
        this.longitudeLengthModel = new ValueUnitPairModel(null);
        this.scanVelocityModel = new ValueUnitPairModel(null);
        this.orientationModel = new ValueUnitPairModel(null);
        this.registerSubModel(this.patternCenterCoordsModel);
        this.registerSubModel(this.latitudeLengthModel);
        this.registerSubModel(this.longitudeLengthModel);
        this.registerSubModel(this.scanVelocityModel);
        this.registerSubModel(this.orientationModel);
        if (object != null) {
            this.setDocument(object);
        }
    }

    public CrossPattern getCrossPattern() {
        return (CrossPattern)((Object)this.document);
    }

    @Override
    public void publish() {
        this.getPatternCenterCoordsModel().publish();
        this.getLatitudeLengthModel().publish();
        this.getLongitudeLengthModel().publish();
        CrossPattern crossPattern = this.getCrossPattern();
        if (crossPattern != null) {
            this.publish(CrossPatternEditor.FID_INITIALSCANDIRECTION, crossPattern.getInitialScanDirection());
        }
        this.getScanVelocityModel().publish();
        this.getOrientationModel().publish();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(CrossPatternEditor.FID_INITIALSCANDIRECTION)) {
            String string = (String)object;
            this.getCrossPattern().setInitialScanDirection(string);
            return string;
        }
        return object;
    }

    @Override
    public void setonlyDocument(Object object) {
        super.setonlyDocument(object);
        CrossPattern crossPattern = this.getCrossPattern();
        if (crossPattern == null) {
            return;
        }
        this.getPatternCenterCoordsModel().setonlyDocument((Object)crossPattern);
        Object object2 = crossPattern.getLatitudeLength();
        this.getLatitudeLengthModel().setonlyDocument(object2);
        object2 = crossPattern.getLongitudeLength();
        this.getLongitudeLengthModel().setonlyDocument(object2);
        object2 = crossPattern.getScanVelocity();
        this.getScanVelocityModel().setonlyDocument(object2);
        object2 = crossPattern.getOrientation();
        this.getOrientationModel().setonlyDocument(object2);
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    public CoordsModel getPatternCenterCoordsModel() {
        return this.patternCenterCoordsModel;
    }

    public ValueUnitPairModel getLongitudeLengthModel() {
        return this.longitudeLengthModel;
    }

    public ValueUnitPairModel getLatitudeLengthModel() {
        return this.latitudeLengthModel;
    }

    public ValueUnitPairModel getScanVelocityModel() {
        return this.scanVelocityModel;
    }

    public ValueUnitPairModel getOrientationModel() {
        return this.orientationModel;
    }
}

