/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;

public class AtmosphericCalObs
extends CalObs {
    private final Flux ZERO_FLUX = Flux.createFlux();

    public AtmosphericCalObs() {
        this.setCalType(CalType.Atmospheric);
    }

    public AtmosphericCalObs(ScienceGoal scienceGoal) {
        this();
        this.scienceGoal = scienceGoal;
        this.configure();
    }

    @Override
    public boolean atmCalRequired(SchedBlock schedBlock) {
        return false;
    }

    @Override
    public Time calTime() throws InvalidFrequencyException, SourceNeverVisibleException {
        if (this.SBSuggestedCalibrationDefaultIntegrationTime != null) {
            return this.SBSuggestedCalibrationDefaultIntegrationTime;
        }
        return AtmosphericCalObs.getCalObsProperties().getAtmosphericCalTime();
    }

    @Override
    public Time cycleTime() {
        if (this.SBSuggestedCalibrationCycleTime != null) {
            return this.SBSuggestedCalibrationCycleTime;
        }
        return AtmosphericCalObs.getCalObsProperties().getAtmosphericCycleTime();
    }

    @Override
    public Frequency getDefaultChannelWidth() {
        if (this.scienceGoal == null || this.scienceGoal.getSpectralSetupParameters().getAbstractScienceSpectralWindowCount() == 0) {
            return Frequency.createFrequencyMHZ(0.48828125);
        }
        return this.scienceGoal.getSpectralSetupParameters().getStringentSpectralWindow().getBandWidth().deepCopy();
    }

    @Override
    public Flux getDefaultFlux() {
        return this.ZERO_FLUX;
    }

    @Override
    public double getDefaultSNR() {
        return 0.0;
    }
}

