/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.calibration.CalibrationTimeEstimater;
import alma.obsprep.services.calibration.CalibrationTimeModel;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;

public class CalibrationTimeEstimaterTest {
    private ScienceGoal createScienceGoal() {
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        TargetParameters targetParameters = TargetParameters.createTargetParameters();
        targetParameters.setSourceName("Sombrero");
        targetParameters.getSourceCoordinates().getLongitude().setContentInDeg(189.99763);
        targetParameters.getSourceCoordinates().getLatitude().setContentInDeg(-11.62306);
        scienceGoal.addTargetParameters(targetParameters);
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow(100.0, null, 1000.0, 0.244140625);
        scienceGoal.getSpectralSetupParameters().addScienceSpectralWindow(0, 0, scienceSpectralWindow);
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        performanceParameters.setRepresentativeFrequency(scienceSpectralWindow.getCenterFrequency());
        performanceParameters.getDesiredLargestScale().setContentAndUnit(1.0, Angle.UNIT_ARCMIN);
        return scienceGoal;
    }

    private SkyCoordinates get3c273coords() {
        SkyCoordinates skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
        skyCoordinates.getLongitude().setContentInDeg(187.2779163);
        skyCoordinates.getLatitude().setContentInDeg(2.0523814);
        return skyCoordinates;
    }

    private void fillCollection(CalibrationTimeEstimater.CalObsCollection calObsCollection) {
        for (CalType calType : CalObs.supportedCal) {
            CalObs calObs = calObsCollection.get(calType);
            calObs.setCalibratorSourceName("3c273");
            calObs.setCalibratorCoordinates(this.get3c273coords());
        }
    }

    public void testBandpass() {
        ScienceGoal scienceGoal = this.createScienceGoal();
        CalibrationTimeModel calibrationTimeModel = new CalibrationTimeModel(null);
        CalibrationTimeEstimater calibrationTimeEstimater = new CalibrationTimeEstimater(calibrationTimeModel);
        CalType calType = CalType.Phase;
        CalibrationTimeEstimater.CalObsCollection calObsCollection = calibrationTimeEstimater.getCalObsCollection();
        calObsCollection.setScienceGoal(scienceGoal);
        this.fillCollection(calObsCollection);
        calibrationTimeModel.setDocument(calObsCollection.get(calType));
        TestUtilities.runTestApp(calibrationTimeEstimater);
    }
}

