/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;

public class DelayCalObs
extends CalObs {
    private final Flux ZERO_FLUX = Flux.createFlux();

    public DelayCalObs() {
        this.setCalType(CalType.Delay);
    }

    public DelayCalObs(ScienceGoal scienceGoal) {
        this();
        this.scienceGoal = scienceGoal;
        this.configure();
    }

    @Override
    public boolean atmCalRequired(SchedBlock schedBlock) {
        return false;
    }

    @Override
    public Frequency getDefaultChannelWidth() {
        if (this.scienceGoal == null || this.scienceGoal.getSpectralSetupParameters().getAbstractScienceSpectralWindowCount() == 0) {
            return Frequency.createFrequencyMHZ(0.48828125);
        }
        return this.scienceGoal.getSpectralSetupParameters().getStringentSpectralWindow().getBandWidth().deepCopy();
    }

    @Override
    public Flux getDefaultFlux() {
        return this.ZERO_FLUX;
    }

    @Override
    public double getDefaultSNR() {
        return 0.0;
    }

    @Override
    public Time calTime() {
        if (this.SBSuggestedCalibrationDefaultIntegrationTime != null) {
            return this.SBSuggestedCalibrationDefaultIntegrationTime;
        }
        return DelayCalObs.getCalObsProperties().getDelayCalTime();
    }

    @Override
    public Time rawCycleTime() {
        if (this.SBSuggestedCalibrationCycleTime != null) {
            return this.SBSuggestedCalibrationCycleTime;
        }
        return DelayCalObs.getCalObsProperties().getDelayCycleTime();
    }
}

