/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JFrame;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;

public class UndeletableSuffixNavigationFilter
extends NavigationFilter {
    private int suffixLength;
    private int prefixLength;
    private final Action deleteNext;
    private final Action deletePrevious;
    private final JTextComponent component;

    public UndeletableSuffixNavigationFilter(int n, int n2, JTextComponent jTextComponent) {
        this.prefixLength = n;
        this.suffixLength = n2;
        this.component = jTextComponent;
        ActionMap actionMap = jTextComponent.getActionMap();
        this.deleteNext = actionMap.get("delete-next");
        actionMap.put("delete-next", new DeleteAction());
        this.deletePrevious = actionMap.get("delete-previous");
        actionMap.put("delete-previous", new BackspaceAction());
        jTextComponent.setCaretPosition(n);
    }

    @Override
    public void setDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
        int n2 = this.component.getText().length() - this.suffixLength;
        int n3 = this.prefixLength;
        if (n > n2) {
            filterBypass.setDot(n2, bias);
        } else if (n < n3) {
            filterBypass.setDot(n3, bias);
        } else {
            filterBypass.setDot(n, bias);
        }
    }

    @Override
    public void moveDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
        int n2 = this.component.getText().length() - this.suffixLength;
        int n3 = this.prefixLength;
        if (n > n2) {
            filterBypass.moveDot(n2, bias);
        } else if (n < n3) {
            filterBypass.moveDot(n3, bias);
        } else {
            filterBypass.moveDot(n, bias);
        }
    }

    public void setSuffixLength(int n) {
        this.suffixLength = n;
    }

    public void setPrefixLength(int n) {
        this.prefixLength = n;
    }

    public static void main(String[] stringArray) throws Exception {
        OTTextField oTTextField = new OTTextField("123456789O", 20);
        oTTextField.setNavigationFilter(new UndeletableSuffixNavigationFilter(2, 3, oTTextField));
        JFrame jFrame = new JFrame("Navigation Filter Example");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(oTTextField);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    private class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = -314693904547973402L;

        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = (JTextComponent)actionEvent.getSource();
            int n = jTextComponent.getText().length() - UndeletableSuffixNavigationFilter.this.suffixLength;
            if (jTextComponent.getCaretPosition() < n) {
                UndeletableSuffixNavigationFilter.this.deleteNext.actionPerformed(null);
            }
        }
    }

    private class BackspaceAction
    extends AbstractAction {
        private static final long serialVersionUID = 3467917101203629260L;

        private BackspaceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = (JTextComponent)actionEvent.getSource();
            if (jTextComponent.getCaretPosition() > UndeletableSuffixNavigationFilter.this.prefixLength) {
                UndeletableSuffixNavigationFilter.this.deletePrevious.actionPerformed(null);
            }
        }
    }
}

