/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.services.generator.refactored.FixedSubscanIntegerMosaicEnforcer;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcer;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcerInterface;
import alma.obsprep.services.generator.refactored.VaryingSubscanIntegerMosaicEnforcer;
import lombok.NonNull;

public class IntegerMosaicEnforcerFactory {
    public static IntegerMosaicEnforcerInterface getIntegerMosaicEnforcer(@NonNull MosaicEnforcer mosaicEnforcer) {
        if (mosaicEnforcer == null) {
            throw new NullPointerException("mosaicEnforcerType is marked non-null but is null");
        }
        IntegerMosaicEnforcer integerMosaicEnforcer = null;
        switch (mosaicEnforcer) {
            case FIXED_SUBSCAN_MOSAIC_ENFORCER: {
                integerMosaicEnforcer = new FixedSubscanIntegerMosaicEnforcer();
                break;
            }
            case VARIABLE_SUBSCAN_MOSAIC_ENFORCER: {
                integerMosaicEnforcer = new VaryingSubscanIntegerMosaicEnforcer();
                break;
            }
            default: {
                throw new RuntimeException("Unable to recognise " + String.valueOf((Object)mosaicEnforcer));
            }
        }
        return integerMosaicEnforcer;
    }

    public static enum MosaicEnforcer {
        FIXED_SUBSCAN_MOSAIC_ENFORCER,
        VARIABLE_SUBSCAN_MOSAIC_ENFORCER;

    }
}

