/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import jsky.catalog.AbstractSearchCondition;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.util.StringUtil;

public class RangeSearchCondition
extends AbstractSearchCondition {
    private Comparable _minVal;
    private Comparable _maxVal;
    private boolean _minInclusive = true;
    private boolean _maxInclusive = true;

    public RangeSearchCondition(FieldDesc fieldDesc, Comparable minVal, Comparable maxVal) {
        super(fieldDesc);
        this._minVal = minVal;
        this._maxVal = maxVal;
    }

    public RangeSearchCondition(FieldDesc fieldDesc, Comparable minVal, boolean minInclusive, Comparable maxVal, boolean maxInclusive) {
        super(fieldDesc);
        this._minVal = minVal;
        this._minInclusive = minInclusive;
        this._maxVal = maxVal;
        this._maxInclusive = maxInclusive;
    }

    public RangeSearchCondition(FieldDesc fieldDesc, double minVal, double maxVal) {
        this(fieldDesc, new Double(minVal), new Double(maxVal));
    }

    public RangeSearchCondition(FieldDesc fieldDesc, String minVal, String maxVal) {
        this(fieldDesc, (Comparable)((Object)minVal.trim()), (Comparable)((Object)maxVal.trim()));
    }

    public Comparable getMinVal() {
        return this._minVal;
    }

    public Comparable getMaxVal() {
        return this._maxVal;
    }

    public boolean isMinInclusive() {
        return this._minInclusive;
    }

    public boolean isMaxInclusive() {
        return this._maxInclusive;
    }

    @Override
    public boolean isTrueFor(Comparable val) {
        if (this._minVal == this._maxVal) {
            if (this._minVal instanceof String && val instanceof String) {
                return StringUtil.match((String)((Object)this._minVal), (String)((Object)val));
            }
            return this._minVal == null || this._minVal.compareTo(val) == 0;
        }
        if (this._minInclusive && this._maxInclusive) {
            return !(this._minVal != null && this._minVal.compareTo(val) > 0 || this._maxVal != null && this._maxVal.compareTo(val) < 0);
        }
        if (this._minInclusive && !this._maxInclusive) {
            return !(this._minVal != null && this._minVal.compareTo(val) > 0 || this._maxVal != null && this._maxVal.compareTo(val) <= 0);
        }
        if (!this._minInclusive && this._maxInclusive) {
            return !(this._minVal != null && this._minVal.compareTo(val) >= 0 || this._maxVal != null && this._maxVal.compareTo(val) < 0);
        }
        return !(this._minVal != null && this._minVal.compareTo(val) >= 0 || this._maxVal != null && this._maxVal.compareTo(val) <= 0);
    }

    @Override
    public boolean isTrueFor(double val) {
        return this.isTrueFor(new Double(val));
    }

    public boolean isRange() {
        return this._minVal != this._maxVal;
    }

    @Override
    public String getValueAsString() {
        if (this._minVal == this._maxVal) {
            if (this._minVal == null) {
                return "";
            }
            return this._minVal.toString();
        }
        String minVal = "";
        if (this._minVal != null) {
            minVal = this._minVal.toString();
        }
        String maxVal = "";
        if (this._maxVal != null) {
            maxVal = this._maxVal.toString();
        }
        return minVal + "," + maxVal;
    }

    public static void main(String[] args) {
        RangeSearchCondition s = new RangeSearchCondition((FieldDesc)new FieldDescAdapter("X"), 0.0, 1.0);
        if (!s.isTrueFor(0.5)) {
            throw new RuntimeException("test failed for 0.5: " + s);
        }
        if (s.isTrueFor(1.5)) {
            throw new RuntimeException("test failed for 1.5: " + s);
        }
        s = new RangeSearchCondition((FieldDesc)new FieldDescAdapter("S"), "aaa", "kkk");
        if (!s.isTrueFor((Comparable)((Object)"bbb"))) {
            throw new RuntimeException("test failed for \"bbb\": " + s);
        }
        if (s.isTrueFor((Comparable)((Object)"mmm"))) {
            throw new RuntimeException("test failed for \"mmm\": " + s);
        }
        System.out.println("All tests passed");
    }
}

