/*
 * Decompiled with CFR 0.152.
 */
package alma.correlatorSrc.CorrConfigValidator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.ls.LSInput;

class LSInputImpl
implements LSInput {
    String stringData;
    String systemId;
    String publicId;
    String encoding = "UTF-8";
    String baseURI;
    boolean certifiedText;

    LSInputImpl(StreamSource streamSource, String publicId, String systemId, String baseURI) {
        this.publicId = publicId;
        this.systemId = systemId;
        this.baseURI = baseURI;
        this.stringData = this.toXMLString(streamSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toXMLString(StreamSource ss) {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("encoding", this.getEncoding());
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            try (StringWriter sw = new StringWriter();){
                StreamResult sr = new StreamResult(sw);
                tr.transform(ss, sr);
            }
            return sw.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StreamSource getStreamSource() {
        StreamSource ss = new StreamSource(new StringReader(this.stringData));
        ss.setPublicId(this.publicId);
        ss.setSystemId(this.systemId);
        return ss;
    }

    @Override
    public Reader getCharacterStream() {
        return new StringReader(this.stringData);
    }

    @Override
    public void setCharacterStream(Reader characterStream) {
        this.stringData = this.toXMLString(new StreamSource(characterStream));
    }

    @Override
    public InputStream getByteStream() {
        try {
            return new ByteArrayInputStream(this.stringData.getBytes(this.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setByteStream(InputStream byteStream) {
        this.stringData = this.toXMLString(new StreamSource(byteStream));
    }

    @Override
    public String getStringData() {
        return this.stringData;
    }

    @Override
    public void setStringData(String stringData) {
        this.stringData = stringData;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public boolean getCertifiedText() {
        return this.certifiedText;
    }

    @Override
    public void setCertifiedText(boolean certifiedText) {
        this.certifiedText = certifiedText;
    }
}

