/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import gov.fnal.eag.healpix.PixTools;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;
import uk.ac.starlink.table.join.SkyMatchEngine;

public class HEALPixMatchEngine
extends SkyMatchEngine {
    private long nside_;
    private final PixTools pixTools_ = new PixTools();
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.table.join");
    private static final int SCHEME = 0;

    public HEALPixMatchEngine(double separation, boolean useErrors) {
        super(separation, useErrors);
    }

    public void setSeparation(double separation) {
        super.setSeparation(separation);
        double pixelSize = 2.0 * separation;
        double pixelSizeArcSec = pixelSize * 206264.80624709636;
        this.nside_ = new PixTools().GetNSide(pixelSizeArcSec);
    }

    protected Object[] getBins(double ra, double dec, double err) {
        double theta = 1.5707963267948966 - dec;
        Vector3d vec = this.pixTools_.Ang2Vec(theta, ra);
        ArrayList binList = this.pixTools_.query_disc(this.nside_, vec, err, 0, 1);
        return binList.toArray();
    }
}

