/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JFileChooser;
import sun.awt.shell.ShellFolder;

public class BasicFileChooser
extends JFileChooser {
    public BasicFileChooser() {
        this(System.getProperty("user.home"));
    }

    public BasicFileChooser(boolean home) {
        this(home ? System.getProperty("user.home") : System.getProperty("user.dir"));
    }

    public BasicFileChooser(String defaultDirectory) {
        super(defaultDirectory);
        System.setProperty("swing.disableFileChooserSpeedFix", "true");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void approveSelection() {
        if (File.separatorChar == '\\' && this.getFileSelectionMode() == 0) {
            File selectedFile = null;
            if (this.isMultiSelectionEnabled()) {
                File[] selectedFiles = this.getSelectedFiles();
                if (selectedFiles.length != 1) {
                    super.approveSelection();
                    return;
                }
                selectedFile = selectedFiles[0];
            } else {
                selectedFile = this.getSelectedFile();
            }
            if (selectedFile.getPath().endsWith(".lnk")) {
                ShellFolder linkedTo = null;
                try {
                    linkedTo = ShellFolder.getShellFolder(selectedFile).getLinkLocation();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (linkedTo != null) {
                    if (((File)linkedTo).isDirectory()) {
                        this.setCurrentDirectory(linkedTo);
                        return;
                    }
                    if (!linkedTo.equals(selectedFile)) {
                        if (this.isMultiSelectionEnabled()) {
                            this.setSelectedFiles(new File[]{linkedTo});
                        }
                        this.setSelectedFile(linkedTo);
                    }
                }
            }
        }
        super.approveSelection();
    }
}

