/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;
import uk.ac.starlink.util.gui.SelectCharacters;
import uk.ac.starlink.util.gui.SelectCharactersEvent;
import uk.ac.starlink.util.gui.SelectCharactersListener;
import uk.ac.starlink.util.images.ImageHolder;

public class SelectTextField
extends JPanel
implements SelectCharactersListener {
    protected JTextField textField = new JTextField();
    protected JButton charButton = new JButton();
    protected SelectCharacters charChooser = null;
    protected EventListenerList listeners = new EventListenerList();

    public SelectTextField() {
        this.initUI();
    }

    public SelectTextField(String text) {
        this.initUI();
        this.setText(text);
    }

    public SelectTextField(String text, SelectCharacters charChooser) {
        this.initUI();
        this.setText(text);
        this.charChooser = charChooser;
        charChooser.addListener(this);
    }

    protected void initUI() {
        this.setLayout(new GridBagLayout());
        ImageIcon specialIcon = new ImageIcon(ImageHolder.class.getResource("special.gif"));
        this.charButton.setIcon(specialIcon);
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectTextField.this.fireAction(e);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.textField, gbc);
        gbc.weightx = 0.0;
        gbc.fill = 3;
        gbc.gridwidth = 1;
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.charButton, gbc);
        this.charButton.setToolTipText("Select from all characters in font");
        this.charButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectTextField.this.chooseChars();
            }
        });
    }

    protected void chooseChars() {
        if (this.charChooser == null) {
            this.charChooser = new SelectCharacters(this.getTextFont());
            this.charChooser.addListener(this);
        } else {
            this.charChooser.setDisplayFont(this.getTextFont());
            this.charChooser.setVisible(true);
        }
    }

    public void newCharacters(SelectCharactersEvent e) {
        this.insertText(e.getText());
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public void insertText(String text) {
        this.textField.replaceSelection(text);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setTextFont(Font font) {
        this.textField.setFont(font);
        if (this.charChooser != null) {
            this.charChooser.setDisplayFont(this.getTextFont());
        }
    }

    public Font getTextFont() {
        return this.textField.getFont();
    }

    public void setTextColour(Color colour) {
        this.textField.setForeground(colour);
    }

    public Color getTextColour() {
        return this.textField.getForeground();
    }

    public Document getDocument() {
        return this.textField.getDocument();
    }

    public void setToolTipText(String tip) {
        this.textField.setToolTipText(tip);
        super.setToolTipText(tip);
    }

    public void setColumns(int columns) {
        this.textField.setColumns(columns);
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(ActionListener.class, l);
    }

    protected void fireAction(ActionEvent e) {
        Object[] la = this.listeners.getListenerList();
        for (int i = la.length - 2; i >= 0; i -= 2) {
            if (la[i] != (class$java$awt$event$ActionListener == null ? SelectTextField.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)la[i + 1]).actionPerformed(e);
        }
    }
}

