<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:id="Alma/ObsPrep/SchedBlock"
                xmlns:op="Alma/ObsPrep/ObsProject"
		xmlns:vt="Alma/ValueTypes">
		
<!--
Changes:
-->

<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>


<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<!-- This forms the basis of the project document transform, ensuring that the information is copied.
     All other templates will override this to do something else -->

<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="id:SchedBlock">
<SchedBlock xmlns="Alma/ObsPrep/SchedBlock">
  <xsl:attribute name="schemaVersion">10</xsl:attribute>
  <xsl:attribute name="revision"><xsl:value-of select="@revision"/></xsl:attribute>
  <xsl:attribute name="xsi:type">SchedBlock</xsl:attribute>
  <xsl:attribute name="status"><xsl:value-of select="@status"/></xsl:attribute>
  <xsl:apply-templates select="node()"/> 
  <xsl:comment>Converted to V10 by SchedBlock9-10.xslt</xsl:comment>
</SchedBlock>
</xsl:template>

<xsl:template match="id:SchedBlockEntity">
<SchedBlockEntity>
<xsl:attribute name="entityId"><xsl:value-of select="@entityId"/></xsl:attribute>
<xsl:attribute name="entityIdEncrypted"><xsl:value-of select="@entityIdEncrypted"/></xsl:attribute>
<xsl:attribute name="entityTypeName"><xsl:value-of select="@entityTypeName"/></xsl:attribute>
<xsl:attribute name="schemaVersion">10</xsl:attribute>
</SchedBlockEntity>
</xsl:template>

</xsl:stylesheet>
