/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.jdal;

import alma.cdbErrType.CDBXMLErrorEx;
import alma.cdbErrType.wrappers.AcsJCDBXMLErrorEx;
import com.cosylab.CDB.DAL;
import com.cosylab.cdb.jdal.JNDIXMLContext;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.omg.CORBA.ORB;

public class JNDIContext
implements Context {
    protected static ORB orb;
    protected static DAL dal;
    protected final Logger logger;
    protected String name;
    protected String elements;

    public static void setDal(DAL dal) {
        JNDIContext.dal = dal;
    }

    public static void setOrb(ORB orb) {
        JNDIContext.orb = orb;
    }

    public JNDIContext(Logger logger) {
        this(null, null, logger);
    }

    public JNDIContext(String name, String elements, Logger logger) {
        this.logger = logger;
        this.name = name;
        this.elements = elements;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        String lookupName = name.toString();
        String fullLookupName = this.name + "/" + lookupName;
        String daoElements = dal.list_daos(fullLookupName);
        if (daoElements.length() == 0) {
            daoElements = null;
        }
        StringTokenizer token = new StringTokenizer(this.elements);
        while (token.hasMoreTokens()) {
            if (!token.nextElement().equals(lookupName)) continue;
            if (daoElements != null) {
                try {
                    return new JNDIXMLContext(fullLookupName, dal.list_nodes(fullLookupName), dal.get_DAO(fullLookupName), this.logger);
                }
                catch (CDBXMLErrorEx th) {
                    AcsJCDBXMLErrorEx jex = AcsJCDBXMLErrorEx.fromCDBXMLErrorEx((CDBXMLErrorEx)th);
                    NamingException ex2 = new NamingException(jex.getFilename() + ": " + jex.getErrorString());
                    ex2.setRootCause(jex);
                    throw ex2;
                }
                catch (Throwable th) {
                    throw new NamingException("Failed to retrieve DAO: " + fullLookupName);
                }
            }
            return new JNDIContext(fullLookupName, dal.list_nodes(fullLookupName), this.logger);
        }
        if (daoElements != null) {
            token = new StringTokenizer(daoElements);
            while (token.hasMoreTokens()) {
                if (!token.nextElement().equals(lookupName)) continue;
                try {
                    return new JNDIXMLContext(fullLookupName, dal.list_nodes(fullLookupName), dal.get_DAO(fullLookupName), this.logger);
                }
                catch (CDBXMLErrorEx th) {
                    AcsJCDBXMLErrorEx jex = AcsJCDBXMLErrorEx.fromCDBXMLErrorEx((CDBXMLErrorEx)th);
                    NamingException ex2 = new NamingException(jex.getFilename() + ": " + jex.getErrorString());
                    ex2.setRootCause(jex);
                    throw ex2;
                }
                catch (Throwable th) {
                    throw new NamingException("Failed to retrieve DAO: " + fullLookupName);
                }
            }
        }
        throw new NamingException("No name " + fullLookupName);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new JNDIElementEnumeration(new StringTokenizer(this.elements));
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " unable to list");
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new NamingException("Not implemented");
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new NamingException("Not implemented");
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new NamingException("Not implemented");
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new NamingException("Not implemented");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new NamingException("Not implemented");
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new NamingException("Not implemented");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return null;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return null;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return null;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return null;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return null;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return null;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return null;
    }

    public Hashtable getEnvironment() throws NamingException {
        return null;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return null;
    }

    private class JNDIElementEnumeration
    implements NamingEnumeration {
        protected Enumeration names;

        public JNDIElementEnumeration(Enumeration names) {
            this.names = names;
        }

        public Object next() throws NamingException {
            String name = (String)this.names.nextElement();
            return new NameClassPair(name, Context.class.getName());
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.names.hasMoreElements();
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                return false;
            }
        }

        @Override
        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new NoSuchElementException(e.toString());
            }
        }
    }
}

