/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.helpers;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Cache {
    private final Map<Object, Object> map = new HashMap<Object, Object>();
    private final LinkedList<Object> queue = new LinkedList();
    private final int capacity;

    public Cache(int capacity) {
        this.capacity = capacity;
    }

    public void put(Object key, Object content) {
        if (!this.map.containsKey(key)) {
            if (this.map.size() >= this.capacity) {
                Object oldKey = this.queue.removeLast();
                this.map.remove(oldKey);
            }
            this.map.put(key, content);
            this.queue.addLast(key);
        }
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public void remove(Object key) {
        this.queue.remove(key);
        this.map.remove(key);
    }
}

