/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.interfaces;

import alma.ArchiveIdentifierError.wrappers.AcsJRangeExhaustedEx;
import alma.acs.container.archive.Range;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.range.IdentifierRange;
import alma.archive.range.IdentifierRangeEntityT;
import alma.archive.range.RangeT;
import alma.archive.wrappers.ArchiveTimeStamp;
import java.net.URI;

public abstract class IdentifierManager {
    private Range range = null;

    public URI getIdNamespace() throws ArchiveException, DatabaseException, ModuleCriticalException {
        if (this.range == null) {
            this.range = new Range(this.getNewRange());
        }
        try {
            return this.range.next();
        }
        catch (AcsJRangeExhaustedEx e) {
            this.range = null;
            return this.getIdNamespace();
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    public synchronized IdentifierRange getNewRange() throws ArchiveException, DatabaseException, ModuleCriticalException {
        String archiveid = this.getArchiveId();
        long rangeid = this.getRangeId();
        IdentifierRangeEntityT entityt = new IdentifierRangeEntityT();
        entityt.setEntityId(this.createUid(archiveid, rangeid));
        IdentifierRange range = new IdentifierRange();
        range.setIdentifierRangeEntity(entityt);
        ArchiveTimeStamp ts = new ArchiveTimeStamp();
        range.setCreatedTimeStamp(ts.toISOString());
        range.setIsLocked(false);
        range.setArchiveID(archiveid);
        RangeT ranget = new RangeT();
        ranget.setRangeID(Long.toHexString(rangeid));
        ranget.setBaseDocumentID("1");
        range.setRange(ranget);
        this.setRangeId(++rangeid);
        return range;
    }

    private String createUid(String archiveid, long rangeid) {
        String uid = "uid://" + archiveid + "/X" + Long.toHexString(rangeid) + "/X0";
        return uid;
    }

    public synchronized IdentifierRange getNewRange(int size) throws ArchiveException, DatabaseException, ModuleCriticalException {
        IdentifierRange range = this.getNewRange();
        RangeT ranget = range.getRange();
        ranget.setMaxDocumentID(Integer.toHexString(size));
        return range;
    }

    protected abstract void initialize() throws DatabaseException, ModuleCriticalException;

    public abstract void close() throws DatabaseException;

    public abstract String getArchiveId() throws DatabaseException, ModuleCriticalException;

    protected abstract void setArchiveId(String var1) throws DatabaseException, ModuleCriticalException;

    protected abstract long getRangeId() throws DatabaseException, ModuleCriticalException;

    protected abstract void setRangeId(long var1) throws DatabaseException, ModuleCriticalException;
}

