/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.oracle;

import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.oracle.DatabaseReader;
import alma.archive.database.oracle.DatabaseWriter;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public final class IdentifierArchive
extends IdentifierManager {
    private static IdentifierArchive instance;
    private DBConfiguration config;
    private String archID;
    private final Logger logger;
    private final DatabaseReader dbReader;
    private final DatabaseWriter dbWriter;

    private IdentifierArchive(Logger logger, DatabaseReader reader, DatabaseWriter writer) throws DatabaseException, ModuleCriticalException {
        this.logger = logger;
        this.dbReader = reader;
        this.dbWriter = writer;
        this.config = InternalIFFactory.dbConfig;
    }

    public static IdentifierArchive instance(Logger logger, DatabaseReader reader, DatabaseWriter writer) throws DatabaseException, ModuleCriticalException {
        if (instance == null) {
            instance = new IdentifierArchive(logger, reader, writer);
        }
        return instance;
    }

    @Override
    public synchronized URI getIdNamespace() throws ArchiveException, DatabaseException, ModuleCriticalException {
        URI out = this.constructUIDstring(this.getNextUID());
        this.logger.fine("Assigning UID " + String.valueOf(out));
        return out;
    }

    private long getNextUID() throws DatabaseException, ModuleCriticalException, ArchiveException {
        return Long.parseLong(this.dbReader.getLastUIDstored());
    }

    @Override
    public void close() throws DatabaseException {
    }

    protected URI constructUIDstring(long actID) throws ArchiveException {
        String archiveID;
        StringBuffer out = new StringBuffer("uid://");
        try {
            archiveID = this.getArchiveId();
        }
        catch (ModuleCriticalException e1) {
            throw new ArchiveException(e1.getCause());
        }
        out.append(archiveID);
        out.append("/X");
        out.append(Long.toHexString(actID));
        out.append("/X1");
        try {
            return new URI(out.toString());
        }
        catch (URISyntaxException e) {
            this.logger.severe("URI conversion error (long --> URI). long: " + actID);
            throw new ArchiveException("URI conversion error: " + actID);
        }
    }

    public void init() throws DatabaseException, ModuleCriticalException {
    }

    @Override
    public String getArchiveId() throws DatabaseException, ModuleCriticalException {
        if (this.archID == null) {
            try {
                this.archID = this.dbReader.getMetaParamValue("archiveID");
                this.logger.fine("Fetched archiveID: " + this.archID);
            }
            catch (DatabaseException e) {
                throw new ModuleCriticalException(e, 0, "Could not retrieve essential DB parameter: xml_metaInfo, parameter: archiveID");
            }
        }
        try {
            return "X" + String.valueOf(Long.parseLong(this.archID));
        }
        catch (NumberFormatException e) {
            return this.archID;
        }
    }

    @Override
    protected void setArchiveId(String archiveId) throws ModuleCriticalException, DatabaseException {
        if (!this.config.testMode) {
            throw new DatabaseException("Can only set range ID in test mode!");
        }
        try {
            this.logger.warning("Setting archiveID to " + archiveId + ". This is not a normal operation and can severely disrupt Archive operations!");
            this.dbWriter.setMetaParamValue("archiveID", archiveId);
        }
        catch (DatabaseException e) {
            throw new ModuleCriticalException(e, 0, "Could not modify essential DB parameter: xml_metaInfo, parameter: archiveID");
        }
    }

    @Override
    protected long getRangeId() throws DatabaseException, ModuleCriticalException {
        try {
            return this.getNextUID();
        }
        catch (ArchiveException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    protected void setRangeId(long rangeId) throws DatabaseException, ModuleCriticalException {
    }

    @Override
    protected void initialize() throws DatabaseException, ModuleCriticalException {
    }
}

