/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import java.net.URL;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayFuncs;
import skyview.executive.Settings;
import skyview.geometry.TransformationException;
import skyview.geometry.WCS;
import skyview.survey.Image;
import skyview.survey.SurveyException;
import skyview.survey.Util;

public class FitsImage
extends Image {
    private String fitsFile;
    private Header fitsHeader;

    public FitsImage(String file) throws SurveyException {
        WCS wcs;
        Header h;
        this.setName(file);
        this.data = null;
        this.fitsFile = file;
        ArrayDataInput inp = null;
        try {
            Fits f = new Fits(file);
            inp = f.getStream();
            h = new Header(inp);
            if (h.getStringValue("REGION") != null) {
                this.setName(h.getStringValue("REGION") + ":" + file);
            }
        }
        catch (Exception e) {
            throw new SurveyException("Unable to read file:" + this.fitsFile);
        }
        finally {
            if (inp != null) {
                try {
                    inp.close();
                }
                catch (Exception e) {}
            }
        }
        int naxis = h.getIntValue("NAXIS");
        if (naxis < 2) {
            throw new SurveyException("Invalid FITS file: " + this.fitsFile + ".  Dimensionality < 2");
        }
        int nx = h.getIntValue("NAXIS1");
        int ny = h.getIntValue("NAXIS2");
        int nz = 1;
        if (h.getIntValue("NAXIS") > 2) {
            nz = h.getIntValue("NAXIS3");
        }
        if (naxis > 3) {
            for (int i = 4; i <= naxis; ++i) {
                if (h.getIntValue("NAXIS" + i) <= 1) continue;
                throw new SurveyException("Invalid FITS file:" + this.fitsFile + ".  Dimensionality > 3");
            }
        }
        try {
            if (Settings.has("PixelOffset")) {
                String[] crpOff = Settings.getArray("PixelOffset");
                try {
                    double d1;
                    double d2 = d1 = Double.parseDouble(crpOff[0]);
                    if (crpOff.length > 0) {
                        d1 = Double.parseDouble(crpOff[1]);
                    }
                    h.addValue("CRPIX1", h.getDoubleValue("CRPIX1") + d1, "");
                    h.addValue("CRPIX2", h.getDoubleValue("CRPIX2") + d2, "");
                }
                catch (Exception e) {
                    System.err.println("Error adding Pixel offset:" + Settings.get("PixelOffset"));
                }
            }
            wcs = new WCS(h);
        }
        catch (TransformationException e) {
            throw new SurveyException("Unable to create WCS for file:" + this.fitsFile + " (" + e + ")");
        }
        try {
            this.initialize(null, wcs, nx, ny, nz);
        }
        catch (TransformationException e) {
            throw new SurveyException("Error generating tranformation for file: " + file);
        }
        this.fitsHeader = h;
    }

    @Override
    public double getData(int npix) {
        Fits f = null;
        if (this.data == null) {
            Object o;
            BasicHDU hdu;
            try {
                try {
                    URL url = new URL(this.fitsFile);
                    f = new Fits(url);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (f == null) {
                    f = new Fits(Util.getResourceOrFile(this.fitsFile));
                }
                hdu = f.readHDU();
                o = hdu.getData().getData();
                f.getStream().close();
            }
            catch (Exception e) {
                throw new Error("Error reading FITS data for file: " + this.fitsFile + "\n\nException was:" + e);
            }
            o = ArrayFuncs.flatten(o);
            if (!(o instanceof double[])) {
                Header h = hdu.getHeader();
                double scale = h.getDoubleValue("BSCALE", 1.0);
                double zero = h.getDoubleValue("BZERO", 0.0);
                boolean bytearray = o instanceof byte[];
                o = ArrayFuncs.convertArray(o, Double.TYPE);
                this.data = (double[])o;
                if (bytearray || scale != 1.0 || zero != 0.0) {
                    for (int i = 0; i < this.data.length; ++i) {
                        if (bytearray && this.data[i] < 0.0) {
                            int n = i;
                            this.data[n] = this.data[n] + 256.0;
                        }
                        this.data[i] = scale * this.data[i] + zero;
                    }
                }
            } else {
                this.data = (double[])o;
            }
            double total = 0.0;
            for (int i = 0; i < this.data.length; ++i) {
                total += this.data[i];
            }
        }
        return this.data[npix];
    }

    public Header getHeader() {
        return this.fitsHeader;
    }
}

