/*
 * Decompiled with CFR 0.152.
 */
package skyview.util;

import java.text.DecimalFormat;
import skyview.util.SmartIntArray;

public class Utilities {
    static final double pi = Math.PI;

    public static double angularDistance(double cx1, double cy1, double cx2, double cy2) {
        double xx1 = Math.toRadians(cx1);
        double yy1 = Math.toRadians(cy1);
        double xx2 = Math.toRadians(cx2);
        double yy2 = Math.toRadians(cy2);
        double distRad = Math.acos(Math.sin(yy1) * Math.sin(yy2) + Math.cos(yy1) * Math.cos(yy2) * Math.cos(xx2 - xx1));
        return Math.toDegrees(distRad);
    }

    public static double[] minMaxInArray(double[] d) {
        if (d == null || d.length == 0) {
            return null;
        }
        double currentMax = d[0];
        double currentMin = d[0];
        for (int i = 1; i < d.length; ++i) {
            if (d[i] > currentMax) {
                currentMax = d[i];
                continue;
            }
            if (!(d[i] < currentMin)) continue;
            currentMin = d[i];
        }
        return new double[]{currentMin, currentMax};
    }

    public static int maxInArray(int[] d) {
        if (d == null || d.length == 0) {
            return 0;
        }
        int currentMax = d[0];
        for (int i = 1; i < d.length; ++i) {
            if (d[i] <= currentMax) continue;
            currentMax = d[i];
        }
        return currentMax;
    }

    public static double maxInArray(double[] d) {
        if (d == null || d.length == 0) {
            return Double.NaN;
        }
        double currentMax = d[0];
        for (int i = 1; i < d.length; ++i) {
            if (!(d[i] > currentMax)) continue;
            currentMax = d[i];
        }
        return currentMax;
    }

    public static double minInArray(double[] d) {
        if (d == null || d.length == 0) {
            return Double.NaN;
        }
        double currentMin = d[0];
        for (int i = 1; i < d.length; ++i) {
            if (!(d[i] < currentMin)) continue;
            currentMin = d[i];
        }
        return currentMin;
    }

    public static double adjustCoordX(double c) {
        if (c > Math.PI) {
            c -= Math.PI * 2;
        } else if (c < -Math.PI) {
            c += Math.PI * 2;
        }
        return c;
    }

    public static double adjustCoordY(double c) {
        if (c < -1.5707963267948966) {
            c = -Math.PI - c;
        } else if (c > 1.5707963267948966) {
            c = Math.PI - c;
        }
        return c;
    }

    public static int[] whereNaNInArray(double[] d) {
        SmartIntArray hold = new SmartIntArray(d.length);
        int count = 0;
        for (int ii = 0; ii < d.length; ++ii) {
            if (!Double.isNaN(d[ii])) continue;
            hold.add(ii);
            ++count;
        }
        if (count > 0) {
            return hold.toArray();
        }
        return new int[0];
    }

    public static int[] whereInArray(double[] d, double searchValue) {
        SmartIntArray hold = new SmartIntArray(d.length);
        int count = 0;
        for (int ii = 0; ii < d.length; ++ii) {
            if (d[ii] != searchValue) continue;
            hold.add(ii);
            ++count;
        }
        if (count > 0) {
            return hold.toArray();
        }
        return new int[0];
    }

    public static int[] whereInArray(double[] d, String operation, double searchValue) {
        SmartIntArray hold = new SmartIntArray(d.length);
        int count = 0;
        if (operation.equals("==")) {
            return Utilities.whereInArray(d, searchValue);
        }
        if (operation.equals("<")) {
            for (int ii = 0; ii < d.length; ++ii) {
                if (!(d[ii] < searchValue)) continue;
                hold.add(ii);
                ++count;
            }
        } else if (operation.equals(">")) {
            for (int ii = 0; ii < d.length; ++ii) {
                if (!(d[ii] > searchValue)) continue;
                hold.add(ii);
                ++count;
            }
        } else if (operation.equals("!=")) {
            for (int ii = 0; ii < d.length; ++ii) {
                if (d[ii] == searchValue) continue;
                hold.add(ii);
                ++count;
            }
        } else if (operation.equals(">=")) {
            for (int ii = 0; ii < d.length; ++ii) {
                if (!(d[ii] >= searchValue)) continue;
                hold.add(ii);
                ++count;
            }
        } else if (operation.equals("<=")) {
            for (int ii = 0; ii < d.length; ++ii) {
                if (!(d[ii] <= searchValue)) continue;
                hold.add(ii);
                ++count;
            }
        }
        if (count > 0) {
            return hold.toArray();
        }
        return new int[0];
    }

    public static double convertNotation(String str) {
        int e_loc = str.indexOf(101);
        double val = Double.valueOf(str.substring(0, e_loc - 1).trim()) * Math.pow(10.0, Double.valueOf(str.substring(e_loc + 1, str.length()).trim()));
        return val;
    }

    public static String sexagesimal(double value, int precision) {
        double[] offset = new double[]{0.5, 0.05, 0.008333333333333333, 8.333333333333334E-4, 1.388888888888889E-4};
        if (precision > 9) {
            precision = 9;
        }
        double delta = precision < 0 ? offset[0] : (precision >= offset.length ? offset[offset.length - 1] / Math.pow(10.0, precision - offset.length + 1) : offset[precision]);
        StringBuffer str = new StringBuffer();
        if (value < 0.0) {
            value = Math.abs(value);
            str.append("-");
        }
        DecimalFormat f = new DecimalFormat("#00");
        if (precision <= 0) {
            str.append(f.format(new Double(value)));
        } else if (precision == 1) {
            f = new DecimalFormat("#00.0");
            str.append(f.format(new Double(value)));
        } else {
            value += delta;
            if (precision == 2) {
                long nelem = (long)(60.0 * value);
                int deg = (int)(nelem / 60L);
                int min = (int)(nelem % 60L);
                str.append(f.format(new Integer(deg)) + " " + f.format(new Integer(min)));
            } else if (precision == 3) {
                long nelem = (long)(600.0 * value);
                int deg = (int)(nelem / 600L);
                int min = (int)(nelem % 600L) / 10;
                int frac = (int)(nelem % 10L);
                str.append(f.format(new Integer(deg)) + " " + f.format(new Integer(min)) + "." + frac);
            } else if (precision == 4) {
                long nelem = (long)(3600.0 * value);
                int deg = (int)(nelem / 3600L);
                int min = (int)(nelem % 3600L) / 60;
                int sec = (int)(nelem % 60L);
                str.append(f.format(new Integer(deg)) + " " + f.format(new Integer(min)) + " " + f.format(new Integer(sec)));
            } else {
                double mult = Math.pow(10.0, precision - 4);
                long fracMod = (long)mult;
                long nelem = (long)((double)(3600L * fracMod) * value);
                int deg = (int)(nelem / (3600L * fracMod));
                int min = (int)(nelem % (3600L * fracMod) / (60L * fracMod));
                int sec = (int)(nelem % (60L * fracMod) / fracMod);
                str.append(f.format(new Integer(deg)) + " " + f.format(new Integer(min)) + " " + f.format(new Integer(sec)) + ".");
                int frac = (int)(nelem % fracMod);
                int divisor = 1;
                for (int i = 5; i < precision; ++i) {
                    divisor *= 10;
                }
                while (divisor > 0) {
                    str.append((char)(48 + frac / divisor % 10));
                    divisor /= 10;
                }
            }
        }
        return str.toString();
    }

    public static double[] average3dData(double[][] data) {
        int bands = data.length;
        int size = data[0].length;
        double[] baseArray = new double[size];
        System.arraycopy(data[0], 0, baseArray, 0, data[0].length);
        if (bands == 1) {
            return baseArray;
        }
        int bandsToAverage = data.length;
        for (int i = 1; i < bands; ++i) {
            for (int j = 0; j < size; ++j) {
                int n = j;
                baseArray[n] = baseArray[n] + data[i][j];
            }
        }
        int j = 0;
        while (j < size) {
            int n = j++;
            baseArray[n] = baseArray[n] * (1.0 / (double)bands);
        }
        return baseArray;
    }

    public static Object newInstance(String cls, String pkg) {
        Object o = null;
        if (pkg != null) {
            try {
                String fullName = pkg + "." + cls;
                o = Class.forName(pkg + "." + cls).newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (o == null) {
            try {
                o = Class.forName(cls).newInstance();
            }
            catch (Exception e) {
                System.err.println("  Unable to instantiate dynamic class " + cls + " in package " + pkg);
            }
        }
        return o;
    }
}

