/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.ACS.ACSComponentOperations;
import alma.JavaContainerError.wrappers.AcsJJavaComponentHelperEx;
import alma.acs.component.ComponentLifecycle;
import alma.acs.component.dynwrapper.DynamicProxyFactory;
import alma.acs.logging.ClientLogManager;
import alma.maciErrType.wrappers.AcsJComponentCreationEx;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.PortableServer.Servant;

public abstract class ComponentHelper {
    private ComponentLifecycle m_componentImpl;
    private final Logger m_containerLogger;
    protected String componentInstanceName;

    public ComponentHelper(Logger containerLogger) {
        this.m_containerLogger = containerLogger;
    }

    final void setComponentInstanceName(String name) {
        this.componentInstanceName = name;
    }

    protected final Logger getComponentLogger() {
        String loggerName = this.componentInstanceName != null ? this.componentInstanceName : "ComponentHelper";
        return ClientLogManager.getAcsLogManager().getLoggerForComponent(loggerName);
    }

    protected final synchronized ComponentLifecycle getComponentImpl() throws AcsJComponentCreationEx, AcsJJavaComponentHelperEx {
        if (this.m_componentImpl == null) {
            Class<?> internalIF = null;
            try {
                this.m_componentImpl = this._createComponentImpl();
                internalIF = this.getInternalInterface();
            }
            catch (AcsJComponentCreationEx ex) {
                throw ex;
            }
            catch (AcsJJavaComponentHelperEx ex) {
                throw ex;
            }
            catch (Throwable thr) {
                throw new AcsJComponentCreationEx(thr);
            }
            if (this.m_componentImpl == null) {
                AcsJComponentCreationEx ex = new AcsJComponentCreationEx();
                ex.setReason("_createComponentImpl() returned null.");
                throw ex;
            }
            if (!internalIF.isInstance(this.m_componentImpl)) {
                AcsJJavaComponentHelperEx ex = new AcsJJavaComponentHelperEx();
                ex.setContextInfo("component impl class '" + this.m_componentImpl.getClass().getName() + "' does not implement the specified functional IF " + internalIF.getName());
                throw ex;
            }
            if (!ACSComponentOperations.class.isInstance(this.m_componentImpl)) {
                AcsJJavaComponentHelperEx ex = new AcsJJavaComponentHelperEx();
                ex.setContextInfo("component impl class '" + this.m_componentImpl.getClass().getName() + "' does not implement the mandatory IF " + ACSComponentOperations.class.getName() + ". Check the IDL interface definition, and add ': ACS::ACSComponent'.");
                throw ex;
            }
            this.m_containerLogger.finer("component '" + this.componentInstanceName + "' (class '" + this.m_componentImpl.getClass().getName() + "') instantiated.");
        }
        return this.m_componentImpl;
    }

    protected abstract ComponentLifecycle _createComponentImpl() throws AcsJComponentCreationEx;

    final Class<? extends Servant> getPOATieClass() throws AcsJJavaComponentHelperEx {
        Class<? extends Servant> poaTieClass = null;
        try {
            poaTieClass = this._getPOATieClass();
        }
        catch (Throwable thr) {
            AcsJJavaComponentHelperEx ex = new AcsJJavaComponentHelperEx(thr);
            ex.setContextInfo("failed to obtain the POATie class from component helper.");
            throw ex;
        }
        if (poaTieClass == null) {
            AcsJJavaComponentHelperEx ex = new AcsJJavaComponentHelperEx();
            ex.setContextInfo("received null as the POATie class from the component helper.");
            throw ex;
        }
        if (!Servant.class.isAssignableFrom(poaTieClass)) {
            AcsJJavaComponentHelperEx ex = new AcsJJavaComponentHelperEx();
            ex.setContextInfo("received invalid POATie class that is not a subclass of org.omg.PortableServer.Servant");
            throw ex;
        }
        if (!this.getOperationsInterface().isAssignableFrom(poaTieClass)) {
            AcsJJavaComponentHelperEx ex = new AcsJJavaComponentHelperEx();
            ex.setContextInfo("POATie class '" + poaTieClass + "' does not implement the declared operations interface '" + this.getOperationsInterface().getName() + "'.");
            throw ex;
        }
        return poaTieClass;
    }

    protected abstract Class<? extends Servant> _getPOATieClass();

    public final Class<? extends ACSComponentOperations> getOperationsInterface() throws AcsJJavaComponentHelperEx {
        Class<? extends ACSComponentOperations> opIF = null;
        try {
            opIF = this._getOperationsInterface();
        }
        catch (Throwable thr) {
            AcsJJavaComponentHelperEx ex = new AcsJJavaComponentHelperEx(thr);
            ex.setContextInfo("failed to retrieve 'operations' interface from component helper");
            throw ex;
        }
        if (opIF == null) {
            AcsJJavaComponentHelperEx ex = new AcsJJavaComponentHelperEx();
            ex.setContextInfo("received null as the 'operations' IF class from the component helper.");
            throw ex;
        }
        return opIF;
    }

    protected abstract Class<? extends ACSComponentOperations> _getOperationsInterface();

    protected Class<?> getInternalInterface() throws AcsJJavaComponentHelperEx {
        return this.getOperationsInterface();
    }

    final Object getInterfaceTranslator() throws AcsJJavaComponentHelperEx {
        Object interfaceTranslator = null;
        Object defaultInterfaceTranslator = null;
        try {
            defaultInterfaceTranslator = DynamicProxyFactory.getDynamicProxyFactory(this.m_containerLogger).createServerProxy(this.getOperationsInterface(), this.m_componentImpl, this.getInternalInterface());
        }
        catch (Throwable thr) {
            throw new AcsJJavaComponentHelperEx(thr);
        }
        try {
            interfaceTranslator = this._getInterfaceTranslator(defaultInterfaceTranslator);
        }
        catch (Throwable thr) {
            AcsJJavaComponentHelperEx ex = new AcsJJavaComponentHelperEx(thr);
            ex.setContextInfo("failed to obtain the custom interface translator.");
            throw ex;
        }
        if (interfaceTranslator == null) {
            interfaceTranslator = defaultInterfaceTranslator;
        }
        return interfaceTranslator;
    }

    protected Object _getInterfaceTranslator(Object defaultInterfaceTranslator) throws AcsJJavaComponentHelperEx {
        return null;
    }

    final String[] getComponentMethodsExcludedFromInvocationLogging() {
        String[] ret = null;
        try {
            ret = this._getComponentMethodsExcludedFromInvocationLogging();
        }
        catch (Exception ex) {
            this.m_containerLogger.log(Level.WARNING, "failed to obtain the list of component methods to exclude from automatic logging.", ex);
        }
        return ret;
    }

    protected String[] _getComponentMethodsExcludedFromInvocationLogging() {
        return null;
    }

    protected boolean requiresOrbCentralLogSuppression() {
        return false;
    }
}

