/*
 * Decompiled with CFR 0.152.
 */
package alma.hla.datamodel.workflow;

import alma.hla.datamodel.gen.meta.AlmaEnumeration;
import alma.hla.datamodel.gen.meta.AlmaModel;
import alma.hla.datamodel.gen.meta.MetaFactory;
import java.io.File;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.AbstractEMFWorkflowComponent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;

public class EnumerationWorkflowInitializer
extends AbstractEMFWorkflowComponent {
    private String cvsRevision;
    private String cvsBranch;
    private String lastModifiedDate;
    private String modelSlot;
    private String enumerationsFile;

    public void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)UMLPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        this.cvsRevision = "-1";
        this.cvsBranch = "";
        this.lastModifiedDate = null;
        File file = new File(this.enumerationsFile);
        URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)this.enumerationsFile);
        Resource inres = resourceSet.getResource(uri, true);
        Model model = (Model)inres.getContents().get(0);
        AlmaModel almaModel = MetaFactory.eINSTANCE.createAlmaModel();
        BasicEList almaEnumList = new BasicEList();
        for (Element element : model.allOwnedElements()) {
            ProfileApplication app;
            Profile prof;
            if (!(element instanceof ProfileApplication) || !(prof = (app = (ProfileApplication)element).getAppliedProfile()).getName().equals("ASDM_Profile")) continue;
            for (Element profEl : prof.allOwnedElements()) {
                if (!(profEl instanceof Enumeration)) continue;
                Enumeration ee = (Enumeration)profEl;
                AlmaEnumeration almaEnum = MetaFactory.eINSTANCE.createAlmaEnumeration();
                almaEnum.init(ee);
                almaEnum.setAlmaModel(almaModel);
                almaEnumList.add((Object)almaEnum);
            }
        }
        almaModel.setCvsRevision(this.cvsRevision);
        almaModel.setCvsBranch(this.cvsBranch);
        almaModel.setModelFile(this.enumerationsFile);
        almaModel.setLastModifiedDate(this.lastModifiedDate);
        almaModel.setAlmaEnumList((EList<AlmaEnumeration>)almaEnumList);
        ctx.set(this.modelSlot, (Object)almaModel);
    }

    public void setEnumerationsFile(String enumerationsFile) {
        System.out.println("- ----- EnumerationsWorkflowInitializer.setEnumerationsFile : " + enumerationsFile);
        this.enumerationsFile = enumerationsFile;
    }

    public void checkConfiguration(Issues issues) {
    }

    public void setModelSlot(String modelSlot) {
        System.out.println("- ----- EnumerationsWorkflowInitializer.setModelSlot: " + modelSlot);
        this.modelSlot = modelSlot;
    }
}

