/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table.reduction;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Antennae {
    NO_ANTENNA(null),
    DV("DV\\d\\d"),
    DA("DA\\d\\d"),
    PM("PM\\d\\d"),
    CM("CM\\d\\d");

    public final Pattern pattern;

    private Antennae(String pattern) {
        this.pattern = pattern != null ? Pattern.compile(pattern) : null;
    }

    public static Antennae matchAntenna(String messageToMatch) {
        if (messageToMatch == null || messageToMatch.isEmpty()) {
            return NO_ANTENNA;
        }
        for (Antennae ant : Antennae.values()) {
            Matcher m;
            if (ant == NO_ANTENNA || !(m = ant.pattern.matcher(messageToMatch)).find()) continue;
            return ant;
        }
        return NO_ANTENNA;
    }

    public static String matchAndReplaceAntenna(StringBuilder messageToMatch, String placeHolder) {
        for (Antennae ant : Antennae.values()) {
            Matcher m;
            if (ant == NO_ANTENNA || !(m = ant.pattern.matcher(messageToMatch)).find()) continue;
            int start = m.start();
            int end = m.end();
            String ret = messageToMatch.substring(start, end);
            messageToMatch.replace(start, end, placeHolder);
            return ret;
        }
        return null;
    }
}

