/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.search;

import alma.acs.logging.table.LogEntryTable;
import alma.acs.logging.table.LogTableDataModel;
import alma.acs.util.IsoDateFormat;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchEngine {
    private LogTableDataModel logTableDataModel;
    private LogEntryTable logEntryTable;

    public SearchEngine(LogEntryTable let) {
        this.logEntryTable = let;
        this.logTableDataModel = let.getLCModel();
    }

    public int find(String searchString, boolean caseSensitive, boolean wholeWord, boolean forwardSearch, boolean[] cols) {
        return this.find(null, searchString, caseSensitive, wholeWord, forwardSearch, cols);
    }

    public int find(Pattern regExp, boolean forwardSearch, boolean[] cols) {
        return this.find(regExp, null, true, true, forwardSearch, cols);
    }

    private int find(Pattern regExp, String searchString, boolean caseSensitive, boolean wholeWord, boolean forwardSearch, boolean[] cols) {
        int startingRow = this.getStartingRow(forwardSearch);
        int endRow = forwardSearch ? this.logEntryTable.getRowCount() - 1 : 0;
        FieldPosition pos = new FieldPosition(0);
        StringBuffer tempSB = new StringBuffer();
        int cursor = startingRow;
        if (endRow < startingRow) {
            int temp = startingRow;
            startingRow = endRow;
            endRow = temp;
        }
        int foundRow = -1;
        while (cursor >= startingRow && cursor <= endRow && foundRow == -1) {
            ILogEntry log = this.logTableDataModel.getVisibleLogEntry(this.logEntryTable.convertRowIndexToModel(cursor));
            String string = null;
            for (int t = 0; t < cols.length - 1; ++t) {
                Object obj = log.getField(LogField.values()[t]);
                if (obj == null || !cols[t]) continue;
                switch (LogField.values()[t]) {
                    case TIMESTAMP: {
                        IsoDateFormat df = new IsoDateFormat();
                        Date dt = new Date((Long)obj);
                        tempSB.delete(0, tempSB.length());
                        df.format(dt, tempSB, pos);
                        string = tempSB.toString();
                        break;
                    }
                    case ENTRYTYPE: 
                    case LINE: 
                    case PRIORITY: 
                    case STACKLEVEL: {
                        string = obj.toString();
                        break;
                    }
                    default: {
                        string = obj.toString();
                    }
                }
                if (!this.matches(string, regExp, searchString, caseSensitive, wholeWord) || (!forwardSearch || cursor == startingRow) && (forwardSearch || cursor == endRow)) continue;
                foundRow = cursor++;
                if (!forwardSearch) {
                    --cursor;
                }
                return foundRow;
            }
            if (cols[cols.length - 1] && log.hasDatas()) {
                Vector addData = log.getAdditionalData();
                for (int t = 0; t < addData.size(); ++t) {
                    ILogEntry.AdditionalData data = (ILogEntry.AdditionalData)addData.elementAt(t);
                    string = data.name;
                    if (this.matches(string, regExp, searchString, caseSensitive, wholeWord) && (forwardSearch && cursor != startingRow || !forwardSearch && cursor != endRow)) {
                        foundRow = cursor++;
                        if (!forwardSearch) {
                            --cursor;
                        }
                        return foundRow;
                    }
                    string = data.value;
                    if (!this.matches(string, regExp, searchString, caseSensitive, wholeWord) || (!forwardSearch || cursor == startingRow) && (forwardSearch || cursor == endRow)) continue;
                    foundRow = cursor++;
                    if (!forwardSearch) {
                        --cursor;
                    }
                    return foundRow;
                }
            }
            if (forwardSearch) {
                ++cursor;
                continue;
            }
            --cursor;
        }
        return foundRow;
    }

    private boolean matches(Object obj, Pattern regExp, String searchString, boolean caseSensitive, boolean wholeWord) {
        String str;
        if (obj == null) {
            return false;
        }
        try {
            str = obj.toString();
        }
        catch (Exception e) {
            System.err.println("Impossible to convert this object to a String: " + obj);
            return false;
        }
        if (regExp == null) {
            String searchStrUpper;
            if (wholeWord) {
                if (caseSensitive) {
                    return str.compareTo(searchString) == 0;
                }
                return str.compareToIgnoreCase(searchString) == 0;
            }
            if (caseSensitive) {
                return str.indexOf(searchString) != -1;
            }
            String upperStr = str.toUpperCase();
            return upperStr.indexOf(searchStrUpper = searchString.toUpperCase()) != -1;
        }
        Matcher matcher = regExp.matcher(str);
        return matcher.matches();
    }

    private int getStartingRow(boolean forward) {
        int ret = this.logEntryTable.getSelectedRow();
        if (ret == -1) {
            ret = forward ? 0 : this.logEntryTable.getRowCount() - 1;
        }
        return ret;
    }
}

